/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.arima;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixMathImpl;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.multivariate.NormalRvg;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.arima.ARIMAModel;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime.SimpleMultiVariateTimeSeries;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class ARIMASim
extends SimpleMultiVariateTimeSeries {
    public ARIMASim(int n, ARIMAModel arima) {
        this(n, arima, new UniformRng().nextLong());
    }

    public ARIMASim(int n, ARIMAModel arima, long seed) {
        super(ARIMASim.b(n, arima, seed).t());
    }

    private static DenseMatrix b(int a2, ARIMAModel a3, long a4) {
        int a5;
        int a6;
        int a7;
        Object a8;
        int a9;
        int a10;
        int a11 = a3.maxPQ();
        SuanShuUtils.assertArgument(a2 > a11, "time series length > max(p, q)", new Object[0]);
        int a12 = a2 + a11 + a3.d();
        DenseMatrix a13 = new DenseMatrix(a3.dimension(), a12);
        NormalRvg a14 = new NormalRvg(new DenseVector(R.rep(0.0, a3.dimension())), a3.sigma());
        long[] lArray = new long[1];
        lArray[0] = a4;
        a14.seed(lArray);
        int n = a10 = 1;
        while (n <= a12) {
            a13.setColumn(a10, a14.nextVector());
            n = ++a10;
        }
        DenseMatrix a22 = new DenseMatrix(new DenseMatrix(a3.dimension(), a12).ZERO());
        int n2 = a9 = a11 + 1;
        while (n2 <= a12) {
            DenseMatrix a15 = null;
            if (a3.p() > 0) {
                int a16;
                a15 = new DenseMatrix(new DenseMatrix(a3.dimension(), a3.p()).ZERO());
                int n3 = a16 = 1;
                while (n3 <= a3.p()) {
                    a15.setColumn(a16, a22.getColumn(a9 - a16));
                    n3 = ++a16;
                }
            }
            a8 = null;
            if (a3.q() > 0) {
                a8 = new DenseMatrix(new DenseMatrix(a3.dimension(), a3.q()).ZERO());
                int n4 = a7 = 1;
                while (n4 <= a3.q()) {
                    ((MatrixMathImpl)a8).setColumn(a7, a13.getColumn(a9 - a7));
                    n4 = ++a7;
                }
            }
            a22.setColumn(a9, a3.getArma().armaMean(a15, (Matrix)a8).getColumn(1).add(new DenseVector(a13.getColumn(a9))));
            n2 = ++a9;
        }
        DenseMatrix a32 = new DenseMatrix(a3.dimension(), a12 - a3.d());
        int n5 = a6 = 1;
        while (n5 <= a3.dimension()) {
            a8 = a22.getRow(a6).toArray();
            int n6 = a7 = 1;
            while (n6 <= a3.d()) {
                a8 = R.cumsum((double[])a8);
                n6 = ++a7;
            }
            a32.setRow(a6, (double[])a8);
            n5 = ++a6;
        }
        DenseMatrix a42 = new DenseMatrix(a3.dimension(), a2);
        int n7 = a5 = 1;
        while (n7 <= a3.dimension()) {
            a42.setRow(a5, Arrays.copyOfRange(a32.getRow(a5).toArray(), a32.nCols() - a2, a32.nCols()));
            n7 = ++a5;
        }
        return a42;
    }
}

