/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.timeseries.portmanteau;

import com.numericalmethod.suanshu.stats.distribution.univariate.ChiSquareDistribution;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.sample.AutoCorrelation;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.sample.AutoCovariance;
import com.numericalmethod.suanshu.stats.timeseries.univariate.realtime.SimpleTimeSeries;

public class BoxPierce
extends HypothesisTest {
    private final int E = 0;

    public BoxPierce(double[] xt, int lag, int fitdf) {
        super(new double[0][]);
        int a2;
        AutoCorrelation a3 = new AutoCorrelation(new SimpleTimeSeries(xt), AutoCovariance.Type.TYPE_I);
        double[] a4 = new double[lag];
        int n = a2 = 0;
        while (n < lag) {
            a4[a2] = a3.evaluate(a2 + 1);
            n = ++a2;
        }
        this.testStatistics = this.Q(a4, xt.length);
        a2 = lag - fitdf;
        ChiSquareDistribution a5 = new ChiSquareDistribution(a2);
        this.pValue = BoxPierce.oneSidedPvalue(a5, this.testStatistics);
    }

    @Override
    public String getAlternativeHypothesis() {
        return "at least one value of autocorrelation coefficient is statistically different from zero at the specified significance level; the data is not random";
    }

    @Override
    public String getNullHypothesis() {
        Object[] objectArray = new Object[1];
        objectArray[0] = 0;
        return String.format("none of the autocorrelation coefficients up to lag %d are different from zero; the data is random", objectArray);
    }

    public double Q(double[] a2, int a3) {
        int a4;
        double a5 = 0.0;
        double[] a6 = a2;
        int a7 = a2.length;
        int n = a4 = 0;
        while (n < a7) {
            double a8 = a6[a4];
            a5 += a8 * a8;
            n = ++a4;
        }
        return (double)a3 * a5;
    }
}

