/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.timeseries.adf;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.signalprocessing.Innovations;
import com.numericalmethod.suanshu.stats.distribution.univariate.EmpiricalDistribution;
import com.numericalmethod.suanshu.stats.regression.linear.LMProblem;
import com.numericalmethod.suanshu.stats.regression.linear.ols.OLSRegression;
import com.numericalmethod.suanshu.stats.test.timeseries.adf.AugmentedDickeyFuller;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class ADFFiniteSampleDistribution
extends EmpiricalDistribution {
    public final int sampleSize;
    public final int nSim;
    public final boolean lagAdjust;
    public final int truncation;
    public final int lagOrder;
    public final AugmentedDickeyFuller.TrendType trend;

    public ADFFiniteSampleDistribution(int sampleSize) {
        this(sampleSize, AugmentedDickeyFuller.TrendType.CONSTANT);
    }

    public ADFFiniteSampleDistribution(int sampleSize, AugmentedDickeyFuller.TrendType trend) {
        this(sampleSize, trend, false, 0);
    }

    public ADFFiniteSampleDistribution(int sampleSize, AugmentedDickeyFuller.TrendType trend, boolean lagAdjust, int lagOrder) {
        this(sampleSize, trend, lagAdjust, lagOrder, 50, 50000);
    }

    public ADFFiniteSampleDistribution(int sampleSize, AugmentedDickeyFuller.TrendType trend, boolean lagAdjust, int lagOrder, int truncation, int nSim) {
        super(ADFFiniteSampleDistribution.b(sampleSize, trend, lagAdjust, lagOrder, truncation, nSim));
        this.sampleSize = sampleSize;
        this.trend = trend;
        this.lagAdjust = lagAdjust;
        this.lagOrder = lagOrder;
        this.truncation = truncation;
        this.nSim = nSim;
    }

    private static double[] b(int a2, AugmentedDickeyFuller.TrendType a3, boolean a4, int a5, int a6, int a7) {
        int a8;
        SuanShuUtils.assertArgument(a5 >= 0 && a6 >= 0, "lagOrder >= 0; truncations >= 0", new Object[0]);
        SuanShuUtils.assertArgument(a4 && a5 > 0 || !a4 && a5 == 0, "if !lagAdjust, then lagOrder == 0; if lagAdjust, then lagOrder > 0", new Object[0]);
        double[] a9 = new double[a7];
        int a10 = a2 + a6;
        int n = a8 = 0;
        while (n < a7) {
            double[] a11 = new Innovations(a10).toArray();
            double[] a12 = R.cumsum(a11);
            a12 = Arrays.copyOfRange(a12, a6, a10);
            double[] a13 = Arrays.copyOfRange(a11, a6 + 1, a10);
            int a14 = a2 - a5 - 1;
            double[] a15 = Arrays.copyOfRange(a13, a5, a5 + a14);
            DenseVector a16 = new DenseVector(a15);
            double[] a17 = Arrays.copyOfRange(a12, 0, a14);
            DenseMatrix a18 = new DenseMatrix(a14, a5 + 1);
            a18.setColumn(1, a17);
            if (a5 > 0) {
                int a19;
                int n2 = a19 = 1;
                while (n2 <= a5) {
                    double[] a20 = Arrays.copyOfRange(a13, a5 - a19, a5 + a14 - a19);
                    a18.setColumn(a19 + 1, a20);
                    n2 = ++a19;
                }
            }
            a9[a8] = a3.getSupport().fromRegression(a16, a18);
            n = ++a8;
        }
        return a9;
    }

    public static double testStat(LMProblem a2) {
        OLSRegression a3 = new OLSRegression(a2);
        double a4 = a3.beta.betaHat.get(1);
        double a5 = a3.beta.stderr.get(1);
        return a4 / a5;
    }

    public static interface TestStat {
        public double fromRegression(Vector var1, Matrix var2);
    }
}

