/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.regression.linear.heteroskedasticity;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.stats.distribution.univariate.ChiSquareDistribution;
import com.numericalmethod.suanshu.stats.regression.linear.LMProblem;
import com.numericalmethod.suanshu.stats.regression.linear.Residuals;
import com.numericalmethod.suanshu.stats.regression.linear.ols.OLSRegression;
import com.numericalmethod.suanshu.stats.test.regression.linear.heteroskedasticity.Heteroskedasticity;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class White
extends Heteroskedasticity {
    private final int L;
    private final int E;

    private double[] b(Vector a2, Vector a3) {
        int a4;
        int a5 = a2.size();
        double[] a6 = new double[a5];
        int n = a4 = 1;
        while (n <= a5) {
            a6[a4 - 1] = a2.get(a4) * a3.get(a4);
            n = ++a4;
        }
        return a6;
    }

    @Override
    public double statistics() {
        if (this.E < this.n) {
            return super.statistics();
        }
        return this.n;
    }

    public White(Residuals residuals) {
        super(residuals);
        this.L = residuals.problem.nExogenousFactors();
        this.E = this.L + this.L * (this.L + 1) / 2;
    }

    @Override
    public OLSRegression getAuxiliaryOLSRegression(Vector y, Residuals residuals) {
        int a2;
        Matrix a3 = residuals.problem.X();
        double[][] a4 = new double[this.E][];
        int a5 = 0;
        int n = a2 = 1;
        while (n <= this.L) {
            a4[a5++] = a3.getColumn(a2).toArray();
            n = ++a2;
        }
        int n2 = a2 = 1;
        while (n2 <= this.L) {
            int n3 = a2;
            while (n3 <= this.L) {
                int a6;
                a4[a5++] = this.b(a3.getColumn(a2), a3.getColumn(a6));
                n3 = ++a6;
            }
            n2 = ++a2;
        }
        DenseMatrix a22 = new DenseMatrix(a4).t();
        LMProblem a7 = new LMProblem(y, (Matrix)a22, true);
        return new OLSRegression(a7);
    }

    @Override
    public ChiSquareDistribution getX2() {
        return new ChiSquareDistribution(this.E);
    }

    @Override
    public OLSRegression getAuxiliaryRegression() {
        OLSRegression a2 = null;
        if (this.E < this.n) {
            ImmutableVector a3 = this.residuals.residuals;
            double a4 = Math.pow(a3.norm(), 2.0) / (double)this.n;
            Vector a5 = a3.pow(2.0).minus(a4);
            a2 = this.getAuxiliaryOLSRegression(a5, this.residuals);
        }
        return a2;
    }
}

