/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.rank.wilcoxon;

import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class WilcoxonSignedRankDistribution
implements UnivariateDistribution {
    public final int N;
    private double[][] E;

    public double pValue(double x) {
        double a2 = this.cdf(x);
        double a3 = this.pValue1SidedGreater(x);
        return 2.0 * Math.min(a3, a2);
    }

    @Override
    @Deprecated
    public double skew() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static int b(int a2) {
        return a2 * (a2 + 1) / 2;
    }

    @Override
    public double density(double x) {
        return this.E[this.N][(int)x];
    }

    @Override
    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double median() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double variance() {
        return (double)(this.N * (this.N + 1) * (2 * this.N + 1)) / 24.0;
    }

    public WilcoxonSignedRankDistribution(int N) {
        int a2;
        int a3;
        int a4;
        this.N = N;
        this.E = new double[N + 1][];
        this.E[0] = new double[1];
        this.E[0][0] = 1.0;
        int n = a4 = 1;
        while (n <= N) {
            a3 = WilcoxonSignedRankDistribution.b(a4);
            this.E[a4] = new double[a3 + 1];
            int n2 = a2 = 0;
            while (n2 <= a3) {
                double a5;
                double d2 = a2 < this.E[a4 - 1].length ? this.E[a4 - 1][a2] : (a5 = 0.0);
                double a6 = a2 - a4 >= 0 ? this.E[a4 - 1][a2 - a4] : 0.0;
                this.E[a4][a2] = a5 + a6;
                n2 = ++a2;
            }
            n = ++a4;
        }
        int n3 = a4 = 1;
        while (n3 <= N) {
            int n4 = a3 = 0;
            while (n4 < this.E[a4].length) {
                int n5 = a2 = 1;
                while (n5 <= a4) {
                    double[] dArray = this.E[a4];
                    int n6 = a3;
                    dArray[n6] = dArray[n6] / 2.0;
                    n5 = ++a2;
                }
                n4 = ++a3;
            }
            n3 = ++a4;
        }
    }

    @Override
    public double mean() {
        return (double)(this.N * (this.N + 1)) / 4.0;
    }

    @Override
    public double quantile(double u) {
        int a2 = 0;
        double a3 = 0.0;
        int a4 = 0;
        int n = a2;
        while (n <= WilcoxonSignedRankDistribution.b(this.N)) {
            int n2 = a4;
            int n3 = a2;
            while (n2 <= n3 && a4 <= WilcoxonSignedRankDistribution.b(this.N)) {
                a3 += this.E[this.N][a4];
                n2 = ++a4;
                n3 = a2;
            }
            if (a3 >= u) break;
            n = ++a2;
        }
        return a2;
    }

    public double pValue1SidedGreater(double x) {
        int a2;
        double a3 = 0.0;
        int n = a2 = 0;
        while (n <= WilcoxonSignedRankDistribution.b(this.N)) {
            if ((double)a2 >= x) {
                a3 += this.E[this.N][a2];
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    @Deprecated
    public double kurtosis() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double cdf(double x) {
        int a2;
        double a3 = 0.0;
        int n = a2 = 0;
        while (n <= WilcoxonSignedRankDistribution.b(this.N)) {
            if ((double)a2 <= x) {
                a3 += this.E[this.N][a2];
            }
            n = ++a2;
        }
        return a3;
    }
}

