/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.rank.wilcoxon;

import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.descriptive.rank.Rank;
import com.numericalmethod.suanshu.stats.distribution.univariate.NormalDistribution;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;
import com.numericalmethod.suanshu.stats.test.rank.wilcoxon.WilcoxonRankSumDistribution;
import java.util.Arrays;

public class WilcoxonRankSum
extends HypothesisTest {
    public final double pValue1SidedLess;
    public final double pValue1SidedGreater;

    public WilcoxonRankSum(double[] sample1, double[] sample2, double mu) {
        this(sample1, sample2, mu, sample1.length + sample2.length < 50, false);
    }

    public WilcoxonRankSum(double[] sample1, double[] sample2, double mu, boolean isExact, boolean isCorrected) {
        int a2;
        int a3;
        int a4;
        double[][] dArrayArray = new double[2][];
        dArrayArray[0] = sample1;
        dArrayArray[1] = sample2;
        super(dArrayArray);
        int a5 = sample1.length;
        int a6 = sample2.length;
        double[] a7 = Arrays.copyOf(sample2, sample2.length);
        int n = a4 = 0;
        while (n < a7.length) {
            int n2 = a4++;
            a7[n2] = a7[n2] + mu;
            n = a4;
        }
        double[][] dArrayArray2 = new double[2][];
        dArrayArray2[0] = sample1;
        dArrayArray2[1] = a7;
        double[] a22 = DoubleUtils.concat(dArrayArray2);
        double[] a8 = new Rank(a22).ranks();
        int a9 = 0;
        int[] a10 = new int[a5 + a6];
        int a11 = 1;
        double[] a12 = a22;
        Arrays.sort(a22);
        int n3 = a3 = 1;
        while (n3 < a5 + a6) {
            a10[a11 - 1] = a12[a3 - 1] == a12[a3] ? a10[a11 - 1] + 1 : a10[a11 - 1];
            a11 = a12[a3 - 1] != a12[a3] ? a11 + 1 : a11;
            n3 = ++a3;
        }
        int n4 = a3 = 0;
        while (n4 < a11) {
            a10[a3] = a10[a3] + 1;
            a9 = a9 + a10[a3] * a10[a3] * a10[a3] - a10[a3];
            n4 = ++a3;
        }
        double a32 = 0.0;
        int n5 = a2 = 0;
        while (n5 < a5) {
            a32 += a8[a2];
            n5 = ++a2;
        }
        this.testStatistics = a32 - (double)(a5 * (a5 + 1) / 2);
        if (isExact) {
            WilcoxonRankSumDistribution a13 = new WilcoxonRankSumDistribution(a5, a6);
            this.pValue1SidedGreater = a13.pValue1SidedGreater(this.testStatistics);
            this.pValue1SidedLess = a13.cdf(this.testStatistics);
            this.pValue = a13.pValue(this.testStatistics);
        } else {
            double a14 = a5 * a6 / 2;
            double a15 = Math.sqrt((double)(a5 * a6) * ((double)this.N + 1.0 - (double)a9 / (double)((a5 + a6) * (a5 + a6 - 1))) / 12.0);
            NormalDistribution a16 = new NormalDistribution(0.0, 1.0);
            if (isCorrected) {
                double a17 = this.testStatistics - a14 > 0.0 ? 0.5 : -0.5;
                double a18 = (this.testStatistics - a14 - a17) / a15;
                this.pValue1SidedGreater = WilcoxonRankSum.oneSidedPvalue(a16, (this.testStatistics - a14 - 0.5) / a15);
                this.pValue1SidedLess = a16.cdf((this.testStatistics - a14 + 0.5) / a15);
                double a19 = a16.cdf(a18);
                this.pValue = 2.0 * Math.min(a19, 1.0 - a19);
            } else {
                double a20 = (this.testStatistics - a14) / a15;
                this.pValue1SidedGreater = WilcoxonRankSum.oneSidedPvalue(a16, a20);
                this.pValue1SidedLess = 1.0 - this.pValue1SidedGreater;
                this.pValue = 2.0 * Math.min(this.pValue1SidedLess, this.pValue1SidedGreater);
            }
        }
    }

    public WilcoxonRankSum(double[] sample1, double[] sample2) {
        this(sample1, sample2, 0.0);
    }

    @Override
    public String getNullHypothesis() {
        return "the means are equal (by offset mu)";
    }

    public WilcoxonRankSum(double[] sample1, double[] sample2, double mu, boolean isExact) {
        this(sample1, sample2, mu, isExact, true);
    }

    @Override
    public String getAlternativeHypothesis() {
        return "the means are different (not by mu)";
    }
}

