/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.rank;

import com.numericalmethod.suanshu.number.Counter;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.descriptive.rank.Rank;
import com.numericalmethod.suanshu.stats.distribution.univariate.ChiSquareDistribution;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;
import java.util.Iterator;

public class KruskalWallis
extends HypothesisTest {
    @Override
    public String getAlternativeHypothesis() {
        return "at least two medians are different";
    }

    @Override
    public String getNullHypothesis() {
        return "all population medians are equal";
    }

    public KruskalWallis(double[] ... samples) {
        super(samples);
        Iterator<Double> a2;
        double[] a3 = DoubleUtils.concat(samples);
        double[] a4 = new Rank(a3).ranks();
        double a5 = 0.0;
        double a6 = 0.0;
        int a7 = 0;
        int a8 = 0;
        int n = a7;
        while (n < this.k) {
            int a9;
            a5 = 0.0;
            int n2 = a9 = 0;
            while (n2 < samples[a7].length) {
                a5 += a4[a8 + a9];
                n2 = ++a9;
            }
            a6 += (double)samples[a7].length * Math.pow(a5 /= (double)samples[a7].length, 2.0);
            a8 += samples[a7].length;
            n = ++a7;
        }
        this.testStatistics = a6 * 12.0 / (double)(this.N * (this.N + 1)) - (double)(3 * (this.N + 1));
        double a22 = 0.0;
        Counter a10 = new Counter();
        a10.add(a4);
        Iterator<Double> iterator = a2 = a10.keySet().iterator();
        while (iterator.hasNext()) {
            Double a11 = a2.next();
            int a12 = a10.count(a11);
            a22 += (double)(a12 * a12 * a12 - a12);
            iterator = a2;
        }
        double a32 = 1.0 - a22 / (double)(this.N * this.N * this.N - this.N);
        this.testStatistics /= a32;
        this.pValue = Double.NaN;
        if (this.testStatistics == 0.0) {
            this.pValue = 1.0;
        } else if (DoubleUtils.isN(this.testStatistics)) {
            ChiSquareDistribution a13 = new ChiSquareDistribution(this.k - 1);
            this.pValue = KruskalWallis.oneSidedPvalue(a13, this.testStatistics);
        }
    }
}

