/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.distribution.pearson;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleArrayMath;
import com.numericalmethod.suanshu.stats.distribution.ProbabilityMassFunction;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;
import com.numericalmethod.suanshu.stats.sampling.discrete.DiscreteSampling;
import java.util.Arrays;
import java.util.Iterator;

public class AS159 {
    private final int[] G;
    private final double[] F;
    private final int k;
    private final RandomLongGenerator L;
    private final int[] E;

    public RandomMatrix nextSample() {
        int a2;
        int a3 = this.G.length - 1;
        int a4 = this.E.length - 1;
        DenseMatrix a5 = new DenseMatrix(a3, a4);
        double a6 = 1.0;
        int[] a7 = Arrays.copyOf(this.E, this.E.length);
        int n = a2 = 1;
        while (n < a3) {
            int a8;
            int a9 = this.G[a2];
            int n2 = a8 = 1;
            while (n2 < a4) {
                Integer a10;
                int a11;
                int a12 = 0;
                int n3 = a11 = a8;
                while (n3 <= a4) {
                    a12 += a7[a11];
                    n3 = ++a11;
                }
                a11 = a12 - a7[a8];
                int a13 = a12 - a9;
                int a14 = a12 - a7[a8] - a9;
                if (a12 == 0) {
                    int n4 = a8;
                    while (n4 <= a4) {
                        int a15;
                        a5.set(a2, a15, 0.0);
                        n4 = ++a15;
                    }
                    break;
                }
                ConditionalDistribution a16 = new ConditionalDistribution(a9, a7[a8], a12, a14, a11, a13, null);
                DiscreteSampling<Integer> a17 = new DiscreteSampling<Integer>(a16, a16);
                Integer n5 = a10 = null;
                while (n5 == null) {
                    n5 = a17.getSample(this.L.nextDouble());
                }
                a5.set(a2, a8, a10.intValue());
                a9 -= a10.intValue();
                int n6 = a8++;
                a7[n6] = a7[n6] - a10;
                a6 *= a16.evaluate(a10);
                n2 = a8;
            }
            a5.set(a2, a4, a9);
            int n7 = a4;
            a7[n7] = a7[n7] - a9;
            n = ++a2;
        }
        int n8 = a2 = 1;
        while (n8 <= a4) {
            a5.set(a3, a2, a7[a2]);
            n8 = ++a2;
        }
        return new RandomMatrix(a5, a6);
    }

    public boolean isValidated(Matrix A) {
        int a2;
        int a3;
        int n = a3 = 1;
        while (n <= A.nRows()) {
            int n2 = a2 = 1;
            while (n2 <= A.nCols()) {
                if (A.get(a3, a2) < 0.0) {
                    return false;
                }
                n2 = ++a2;
            }
            n = ++a3;
        }
        int[] a22 = MatrixUtils.rowSums(A);
        int n3 = a2 = 1;
        while (n3 <= A.nRows()) {
            if (a22[a2 - 1] != this.G[a2]) {
                return false;
            }
            n3 = ++a2;
        }
        a22 = MatrixUtils.colSums(A);
        int n4 = a2 = 1;
        while (n4 <= A.nCols()) {
            if (a22[a2 - 1] != this.E[a2]) {
                return false;
            }
            n4 = ++a2;
        }
        return true;
    }

    public AS159(int[] rowSums, int[] colSums) {
        this(rowSums, colSums, new UniformRng());
    }

    public AS159(int[] rowSums, int[] colSums, RandomLongGenerator rng) {
        int a2;
        int a3;
        int a4;
        this.L = rng;
        SuanShuUtils.assertArgument(rowSums.length > 1, "the contingency table must have at least 2 rows", new Object[0]);
        SuanShuUtils.assertArgument(colSums.length > 1, "the contingency table must have at least 2 columns", new Object[0]);
        int n = a4 = 0;
        while (n < rowSums.length) {
            SuanShuUtils.assertArgument(rowSums[a4] > 0, "a row sum must be +ve", new Object[0]);
            n = ++a4;
        }
        int n2 = a4 = 0;
        while (n2 < colSums.length) {
            SuanShuUtils.assertArgument(colSums[a4] > 0, "a column sum must be +ve", new Object[0]);
            n2 = ++a4;
        }
        a4 = DoubleArrayMath.sum(rowSums);
        SuanShuUtils.assertArgument(a4 == (a3 = DoubleArrayMath.sum(colSums)), "the row sum and the columns sum do not add up equal", new Object[0]);
        this.k = a4;
        this.F = new double[this.k + 1];
        this.F[0] = 0.0;
        double a5 = 0.0;
        int n3 = a2 = 1;
        while (n3 <= this.k) {
            this.F[a2] = a5 += Math.log(a2);
            n3 = ++a2;
        }
        this.G = new int[rowSums.length + 1];
        this.G[0] = 0;
        int n4 = a2 = 0;
        while (n4 < rowSums.length) {
            this.G[a2 + 1] = rowSums[a2];
            n4 = ++a2;
        }
        this.E = new int[colSums.length + 1];
        this.E[0] = 0;
        int n5 = a2 = 0;
        while (n5 < colSums.length) {
            this.E[a2 + 1] = colSums[a2];
            n5 = ++a2;
        }
    }

    public static class 1 {
    }

    private class ConditionalDistribution
    implements Iterable<Integer>,
    ProbabilityMassFunction<Integer> {
        private final int I;
        private int l = 0;
        private double H;
        private final int f;
        private final double M;
        private final int i;
        private double G;
        private double F;
        private final int k;
        private int L = 0;
        private int E = 0;

        public /* synthetic */ ConditionalDistribution(int a3, int a4, int a5, int a6, int a7, int a8, com.numericalmethod.suanshu.stats.test.distribution.pearson.AS159$1 a9) {
            a10(a3, a4, a5, a6, a7, a8);
            ConditionalDistribution a10;
        }

        private ConditionalDistribution(int a2, int a3, int a4, int a5, int a6, int a7) {
            ConditionalDistribution a8;
            a8.f = a2;
            a8.i = a3;
            a8.I = a5;
            a8.k = Math.round((float)a2 * (float)a3 / (float)a4);
            a8.M = Math.exp(a8.AS159.this.F[a2] + a8.AS159.this.F[a7] + a8.AS159.this.F[a3] + a8.AS159.this.F[a6] - a8.AS159.this.F[a8.k] - a8.AS159.this.F[a3 - a8.k] - a8.AS159.this.F[a2 - a8.k] - a8.AS159.this.F[a5 + a8.k] - a8.AS159.this.F[a4]);
            a8.E = a8.k;
            a8.L = a8.k;
            a8.F = a8.M;
            a8.G = a8.M;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public Integer next() {
                    if (ConditionalDistribution.this.l == 0) {
                        ConditionalDistribution.this.l = ConditionalDistribution.this.k;
                        ConditionalDistribution.this.H = ConditionalDistribution.this.M;
                        ConditionalDistribution.this.b();
                        ConditionalDistribution.this.m();
                    } else if (ConditionalDistribution.this.E >= 0 && (ConditionalDistribution.this.l <= ConditionalDistribution.this.k || ConditionalDistribution.this.L < 0)) {
                        ConditionalDistribution.this.l = ConditionalDistribution.this.E;
                        ConditionalDistribution.this.H = ConditionalDistribution.this.F;
                        ConditionalDistribution.this.b();
                    } else if (ConditionalDistribution.this.L >= 0 && (ConditionalDistribution.this.l > ConditionalDistribution.this.k || ConditionalDistribution.this.E < 0)) {
                        ConditionalDistribution.this.l = ConditionalDistribution.this.L;
                        ConditionalDistribution.this.H = ConditionalDistribution.this.G;
                        ConditionalDistribution.this.m();
                    }
                    return ConditionalDistribution.this.l;
                }
                {
                    1 a2;
                }

                @Override
                public boolean hasNext() {
                    if (ConditionalDistribution.this.E < 0 && ConditionalDistribution.this.L < 0) {
                        return false;
                    }
                    return true;
                }
            };
        }

        private void m() {
            double d2;
            ConditionalDistribution a2;
            double a3 = a2.L * (a2.I + a2.L);
            if (d2 > 0.0) {
                --a2.L;
                a2.G *= a3 / ((double)(a2.i - a2.L) * (double)(a2.f - a2.L));
            } else {
                a2.L = -1;
            }
        }

        @Override
        public double evaluate(Integer x) {
            if (x == this.l) {
                return this.H;
            }
            throw new RuntimeException("this probability mass function must be called in order");
        }

        private void b() {
            double d2;
            ConditionalDistribution a2;
            double a3 = (a2.i - a2.E) * (a2.f - a2.E);
            if (d2 > 0.0) {
                ++a2.E;
                a2.F *= a3 / ((double)a2.E * (double)(a2.I + a2.E));
            } else {
                a2.E = -1;
            }
        }
    }

    public static class RandomMatrix {
        public final ImmutableMatrix A;
        public final double prob;

        public RandomMatrix(Matrix A, double prob) {
            this.A = new ImmutableMatrix(A);
            this.prob = prob;
        }
    }
}

