/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.distribution.kolmogorov;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.big.BigIntegerUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class KolmogorovOneSidedDistribution
implements UnivariateDistribution {
    public final int n;
    public final int bigN;

    public static double asymptoticCDF(double m2, double x) {
        return 1.0 - Math.exp(-2.0 * m2 * m2 * x * x);
    }

    @Override
    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double density(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double cdf(double x) {
        if (this.n >= this.bigN) {
            return KolmogorovOneSidedDistribution.asymptoticCDF(Math.sqrt(this.n), x);
        }
        return this.b(x);
    }

    @Override
    @Deprecated
    public double kurtosis() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public KolmogorovOneSidedDistribution(int n, int bigN) {
        this.n = n;
        this.bigN = bigN;
    }

    @Override
    @Deprecated
    public double variance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double mean() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private double b(double a2) {
        double a3 = 0.0;
        if (a2 <= 0.0) {
            a3 = 0.0;
        } else if (a2 >= 1.0) {
            a3 = 1.0;
        } else {
            int a4;
            KolmogorovOneSidedDistribution a5;
            int a6 = (int)Math.floor((double)a5.n * (1.0 - a2));
            int n = a4 = 0;
            while (n <= a6) {
                a3 += Math.exp(Math.log(BigIntegerUtils.combination(a5.n, a4).doubleValue()) + (double)(a5.n - a4) * Math.log(1.0 - a2 - (double)a4 / (double)a5.n) + (double)(a4 - 1) * Math.log(a2 + (double)a4 / (double)a5.n));
                n = ++a4;
            }
            a3 = 1.0 - a2 * a3;
        }
        return a3;
    }

    public KolmogorovOneSidedDistribution(int n) {
        this(n, 50);
    }

    @Override
    @Deprecated
    public double median() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double skew() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double quantile(double q2) {
        SuanShuUtils.assertArgument(this.n >= 50, "supported only for n < 50", new Object[0]);
        double a2 = 1.0 - q2;
        double a3 = Math.log(1.0 / a2) / 2.0 / (double)this.n;
        a3 = Math.sqrt(a3);
        return a3;
    }
}

