/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.stochasticprocess.multivariate.brownian;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.stats.stochasticprocess.multivariate.sde.DiscretizedSDE;
import com.numericalmethod.suanshu.stats.stochasticprocess.multivariate.sde.Ft;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class Brownian
implements DiscretizedSDE {
    public final Vector mu;
    public final int d;
    public final Matrix sigma;

    public Brownian(Vector mu, Matrix sigma) {
        this.d = sigma.nCols();
        this.mu = mu;
        this.sigma = sigma;
    }

    @Override
    public Vector dXt(Ft ft) {
        Vector a2 = ft.dWt();
        a2 = this.sigma == null ? a2 : this.sigma.multiply(a2);
        a2 = this.mu == null ? a2 : a2.add(this.mu.scaled(ft.dt()));
        return a2;
    }

    @Override
    public Ft getNewFt() {
        return new Ft();
    }

    public Brownian(int d2) {
        this.d = d2;
        this.mu = null;
        this.sigma = null;
    }

    @Override
    public int nB() {
        return this.d;
    }
}

