/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.sampling.resampling.bootstrap;

import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;
import com.numericalmethod.suanshu.stats.sampling.resampling.Resampling;
import java.util.Arrays;

public class NonParametricBootstrap
implements Resampling {
    private double[] L;
    private RandomLongGenerator E = new UniformRng();

    public NonParametricBootstrap(double[] sample) {
        this.L = Arrays.copyOfRange(sample, 0, sample.length);
    }

    @Override
    public double[] getResample() {
        int a2;
        double[] a3 = new double[this.L.length];
        int n = a2 = 0;
        while (n < this.L.length) {
            int a4 = (int)(this.E.nextLong() % (long)this.L.length);
            a3[a2] = this.L[a4];
            n = ++a2;
        }
        return a3;
    }

    @Override
    public void seed(long ... seeds) {
        this.E.seed(seeds);
    }
}

