/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.modelselection;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.NormalDistribution;
import com.numericalmethod.suanshu.stats.regression.linear.glm.GLMProblem;
import com.numericalmethod.suanshu.stats.regression.linear.glm.GeneralizedLinearModel;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import java.util.Arrays;

public abstract class SingleFactorSelection {
    public final GLMProblem problem;
    public Indices indices;
    public final double criticalValue;

    public GeneralizedLinearModel getModel() {
        Matrix a2 = this.indices.subA();
        if (a2 == null) {
            throw new ModelNotFound("no factor selected");
        }
        GLMProblem a3 = new GLMProblem((Vector)this.problem.y, a2, this.problem.addIntercept, this.problem.family);
        return new GeneralizedLinearModel(a3);
    }

    public SingleFactorSelection(GLMProblem problem, double significance) {
        SuanShuUtils.assertArgument(significance < 0.5, "significant level should be less than 0.5", new Object[0]);
        this.problem = problem;
        this.criticalValue = new NormalDistribution(0.0, 1.0).quantile(1.0 - significance / 2.0);
    }

    public int[] getFactors() {
        SingleFactorSelection a2;
        return Arrays.copyOf(a2.indices.flags, a2.indices.flags.length);
    }

    public class Indices {
        public final GLMProblem problem;
        public int[] flags;
        public int[] subset;

        public Indices(GLMProblem a2) {
            Indices a3;
            a3.problem = a2;
        }

        public Matrix subA() {
            Indices a2;
            a2.subset = R.select(a2.flags, new R.which(){
                {
                    1 a2;
                }

                @Override
                public boolean isTrue(double x, int index) {
                    return x > 0.0;
                }
            });
            DenseMatrix a3 = a2.subset.length > 0 ? CreateMatrix.columns(a2.problem.A, a2.subset) : null;
            return a3;
        }

        public boolean isSelected(int a2) {
            Indices a3;
            return a3.flags[a2 - 1] > 0;
        }
    }

    public static class ModelNotFound
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ModelNotFound(String msg) {
            super(msg);
        }
    }
}

