/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm.distribution;

import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.Family;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.Identity;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.LinkFunction;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class Gaussian
extends Family {
    @Override
    public double cumulant(double theta) {
        return theta * theta / 2.0;
    }

    @Override
    public double variance(double mu) {
        return 1.0;
    }

    @Override
    public double AIC(Vector y, Vector mu, Vector weight, double preLogLike, double deviance, int nFactors) {
        int a2;
        int a3 = y.size();
        double a4 = deviance / (double)a3;
        double a5 = preLogLike / a4 - (double)a3 * Math.log(Math.PI * 2 * a4) / 2.0;
        int n = a2 = 1;
        while (n <= a3) {
            a5 += -0.5 * Math.pow(y.get(a2), 2.0) / a4;
            n = ++a2;
        }
        return 2.0 * ((double)(nFactors + 1) - a5);
    }

    @Override
    public double dispersion(Vector y, Vector mu, int nFactors) {
        return this.overdispersion(y, mu, nFactors);
    }

    @Override
    public double deviance(double y, double mu) {
        double a2 = y - mu;
        return a2 * a2;
    }

    public Gaussian() {
        this(new Identity());
    }

    @Override
    public double theta(double mu) {
        return mu;
    }

    @Override
    public double overdispersion(Vector y, Vector mu, int nFactors) {
        int a2;
        int a3 = y.size();
        double a4 = 0.0;
        int n = a2 = 1;
        while (n <= a3) {
            a4 += Math.pow(y.get(a2) - mu.get(a2), 2.0);
            n = ++a2;
        }
        return a4 /= (double)(a3 - nFactors);
    }

    public Gaussian(LinkFunction link) {
        super(link);
    }
}

