/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm;

import com.numericalmethod.suanshu.stats.regression.linear.glm.Beta;
import com.numericalmethod.suanshu.stats.regression.linear.glm.Fitting;
import com.numericalmethod.suanshu.stats.regression.linear.glm.GLMProblem;
import com.numericalmethod.suanshu.stats.regression.linear.glm.IWLS;
import com.numericalmethod.suanshu.stats.regression.linear.glm.Residuals;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class GeneralizedLinearModel {
    public final Beta beta;
    public final double AIC;
    public final GLMProblem problem;
    public final Residuals residuals;

    public GeneralizedLinearModel(GLMProblem problem, Fitting fitting) {
        this.problem = problem;
        fitting.fit(problem, new DenseVector(problem.nFactors(), 1.0E-4));
        this.residuals = new Residuals(problem, (Vector)fitting.mu());
        this.beta = new Beta(fitting, this.residuals);
        this.AIC = this.problem.family.AIC(this.problem.y, fitting.mu(), fitting.weights(), fitting.logLikelihood(), this.residuals.deviance, problem.nFactors());
    }

    public GeneralizedLinearModel(GLMProblem problem) {
        this(problem, new IWLS(1.0E-10, 100));
    }
}

