/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.univariate.uniform.linear;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.linear.LinearCongruentialGenerator;
import java.util.concurrent.atomic.AtomicLong;

public class Lehmer
implements LinearCongruentialGenerator {
    public final long r;
    public final long q;
    public final long m;
    public final long a;
    private AtomicLong E = new AtomicLong();

    public Lehmer() {
        this(40014L, 2147483563L, 8682522807148012L + System.nanoTime());
    }

    public Lehmer(long a2, long m2, long seed) {
        SuanShuUtils.assertArgument(a2 > 0L && m2 > 0L, "a and m must be positive", new Object[0]);
        this.a = a2;
        this.m = m2;
        this.q = m2 / a2;
        this.r = m2 % a2;
        SuanShuUtils.assertArgument(this.r <= this.q, "the (a, m) combination is not valid; try a <= sqrt(m)", new Object[0]);
        long[] lArray = new long[1];
        lArray[0] = seed;
        this.seed(lArray);
    }

    @Override
    public void seed(long ... seeds) {
        this.E.set(seeds[0] % this.m);
    }

    @Override
    public double nextDouble() {
        return (double)this.nextLong() / (double)this.m;
    }

    public Lehmer(long a2, long m2, long k, long seed) {
        this(FunctionOps.modpow(a2, k, m2), m2, seed);
    }

    @Override
    public long modulus() {
        return this.m;
    }

    @Override
    public long nextLong() {
        long a2;
        long a3;
        do {
            a2 = a3 = this.E.get();
            long a4 = a3 / this.q;
            if ((a2 = this.a * (a2 - a4 * this.q) - a4 * this.r) >= 0L) continue;
            a2 += this.m;
        } while (!this.E.compareAndSet(a3, a2));
        return a2;
    }

    @Override
    public int order() {
        return 1;
    }
}

