/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.univariate.poisson;

import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.RandomNumberGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;

public class Knuth1969
implements RandomNumberGenerator {
    private final double k;
    private final RandomLongGenerator L;
    private final double E;

    public Knuth1969(double lambda) {
        this(lambda, new UniformRng());
    }

    @Override
    public double nextDouble() {
        double a2;
        int a3 = 0;
        double a4 = 1.0;
        do {
            ++a3;
        } while ((a4 *= (a2 = this.L.nextDouble())) > this.E);
        return a3 - 1;
    }

    public Knuth1969(double lambda, RandomLongGenerator uniform) {
        this.L = uniform;
        this.k = lambda;
        this.E = Math.exp(-lambda);
    }

    @Override
    public void seed(long ... seeds) {
        this.L.seed(seeds);
    }
}

