/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.univariate.normal;

import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.normal.RandomStandardNormalNumberGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;

public class BoxMuller
implements RandomStandardNormalNumberGenerator {
    private boolean F;
    private double k;
    private double L = Double.NaN;
    private final RandomLongGenerator E;

    @Override
    public double nextDouble() {
        if (!this.F) {
            this.b();
            return this.L;
        }
        this.F = false;
        return this.k;
    }

    @Override
    public void seed(long ... seeds) {
        this.E.seed(seeds);
    }

    public BoxMuller(RandomLongGenerator uniform) {
        this.k = Double.NaN;
        this.E = uniform;
        this.b();
    }

    private void b() {
        BoxMuller a2;
        double a3 = a2.E.nextDouble();
        double a4 = a2.E.nextDouble();
        double a5 = -2.0 * Math.log(a3);
        double a6 = Math.PI * 2 * a4;
        a2.L = Math.sqrt(a5) * Math.cos(a6);
        a2.k = Math.sqrt(a5) * Math.sin(a6);
    }

    public BoxMuller() {
        this(new UniformRng());
    }
}

