/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.univariate.gamma;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.gamma.RandomGammaGenerator;

public class KunduGupta2007
implements RandomGammaGenerator {
    private final double H;
    private final double f;
    private final double M;
    private final double i;
    private final double G;
    private final double F;
    private final double k;
    private final double L;
    private final RandomLongGenerator E;

    public KunduGupta2007(double k, double theta, RandomLongGenerator uniform) {
        SuanShuUtils.assertArgument(k > 0.0, "the shape parameter must be > 0", new Object[0]);
        SuanShuUtils.assertArgument(k < 1.0, "the shape parameter must be < 1", new Object[0]);
        SuanShuUtils.assertArgument(theta > 0.0, "the scale parameter must be > 0", new Object[0]);
        this.G = theta;
        this.E = uniform;
        this.M = k;
        this.k = k - 1.0;
        this.f = 1.0334 - 0.0766 * Math.exp(2.2942 * k);
        this.H = Math.pow(2.0, k) * Math.pow(1.0 - Math.exp(-this.f / 2.0), k);
        this.F = k * Math.pow(this.f, this.k) * Math.exp(-this.f);
        this.L = this.H + this.F;
        this.i = this.H / (this.H + this.F);
    }

    @Override
    public double nextDouble() {
        double a2;
        while (true) {
            double a3;
            double d2;
            double a4 = this.E.nextDouble();
            if (d2 < this.i) {
                a2 = 1.0 - 0.5 * Math.pow(this.L * a4, 1.0 / this.M);
                a2 = Math.log(a2);
                a2 *= -2.0;
            } else {
                a2 = this.L * (1.0 - a4);
                a2 /= this.M * Math.pow(this.f, this.k);
                a2 = -Math.log(a2);
            }
            double a5 = this.E.nextDouble();
            if (a2 < this.f) {
                a3 = Math.pow(a2, this.k) * Math.exp(-a2 / 2.0);
                if (!(a5 <= (a3 /= Math.pow(2.0, this.k) * Math.pow(1.0 - Math.exp(-a2 / 2.0), this.k)))) continue;
                return a2 * this.G;
            }
            a3 = Math.pow(this.f / a2, 1.0 - this.M);
            if (a5 <= a3) break;
        }
        return a2 * this.G;
    }

    @Override
    public void seed(long ... seeds) {
        this.E.seed(seeds);
    }
}

