/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.multivariate;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.Cholesky;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.matrix.doubles.operation.positivedefinite.PositiveDefiniteMatrixBySmallDiagonalElements;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.multivariate.IID;
import com.numericalmethod.suanshu.stats.random.multivariate.RandomVectorGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.normal.BoxMuller;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class NormalRvg
implements RandomVectorGenerator {
    private final int F;
    private final ImmutableVector k;
    private final IID L;
    private final ImmutableMatrix E;

    public NormalRvg(Vector mu, Matrix sigma) {
        this(mu, sigma, new UniformRng(), SuanShuUtils.autoEpsilon(MatrixUtils.to1DArray(sigma)));
    }

    public static ImmutableMatrix modifiedCholeskyWang2006(Matrix sigma, double epsilon) {
        PositiveDefiniteMatrixBySmallDiagonalElements a2 = new PositiveDefiniteMatrixBySmallDiagonalElements(sigma, epsilon, epsilon);
        Cholesky a3 = new Cholesky(a2);
        return new ImmutableMatrix(a3.L());
    }

    @Override
    public double[] nextVector() {
        DenseVector a2 = new DenseVector(this.L.nextVector());
        return this.k.add(this.E.multiply(a2)).toArray();
    }

    @Override
    public void seed(long ... seeds) {
        this.L.seed(seeds);
    }

    public NormalRvg(Vector mu, Matrix sigma, RandomLongGenerator uniform, double epsilon) {
        SuanShuUtils.assertArgument(sigma.nRows() == mu.size() && sigma.nCols() == mu.size(), "sigma should be a square matrix of dimension mu.size() by mu.size()", new Object[0]);
        this.F = mu.size();
        this.k = new ImmutableVector(mu);
        this.L = new IID(new BoxMuller(uniform), this.F);
        this.E = NormalRvg.modifiedCholeskyWang2006(sigma, epsilon);
    }

    public NormalRvg(int dim) {
        this(new DenseVector(R.rep(0.0, dim)), new DiagonalMatrix(dim).ONE());
    }
}

