/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.pca;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.svd.SVD;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.stats.pca.PCAImpl;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class PCAbySVD
extends PCAImpl {
    private final boolean F;
    private final boolean k;
    private final ImmutableVector L;
    private final ImmutableVector E;

    public PCAbySVD(Matrix data) {
        this(data, true, true);
    }

    public SVD svd() {
        return new SVD(this.X(), true);
    }

    public PCAbySVD(Matrix data, boolean centered, boolean scaled) {
        this(data, centered, scaled, null, null);
    }

    @Override
    public Matrix loadings() {
        return this.svd().V();
    }

    public PCAbySVD(Matrix data, boolean centered, boolean scaled, Vector mean, Vector scale) {
        super(data);
        this.F = centered;
        this.k = scaled;
        this.E = mean != null ? new ImmutableVector(mean) : null;
        this.L = scale != null ? new ImmutableVector(scale) : null;
    }

    @Override
    public Vector scale() {
        if (this.L != null) {
            return this.L;
        }
        if (this.k) {
            return super.scale();
        }
        return new DenseVector(R.rep(1.0, this.nFactors()));
    }

    @Override
    public DenseVector sdPrincipalComponent() {
        int a2;
        double[] a3 = this.svd().getSingularValues();
        int a4 = a3.length;
        double a5 = Math.sqrt(Math.max(1, this.nObs() - 1));
        double[] a6 = new double[a4];
        int n = a2 = 0;
        while (n < a4) {
            a6[a2] = a3[a2] / a5;
            n = ++a2;
        }
        return new DenseVector(a6);
    }

    @Override
    public Vector mean() {
        if (this.E != null) {
            return this.E;
        }
        if (this.F) {
            return super.mean();
        }
        return new DenseVector(R.rep(0.0, this.nFactors()));
    }
}

