/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.pca;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.descriptive.CorrelationMatrix;
import com.numericalmethod.suanshu.stats.descriptive.CovarianceMatrix;
import com.numericalmethod.suanshu.stats.pca.PCAImpl;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class PCAbyEigen
extends PCAImpl {
    private final boolean L;
    private final ImmutableMatrix E;

    @Override
    public DenseVector proportionVar() {
        int a2;
        DenseVector a3 = this.sdPrincipalComponent();
        double a4 = MatrixMeasure.tr(this.V());
        int a5 = a3.size();
        double[] a6 = new double[a5];
        int n = a2 = 0;
        while (n < a5) {
            a6[a2] = Math.pow(a3.get(a2 + 1), 2.0);
            n = ++a2;
        }
        return new DenseVector(a6).scaled(1.0 / a4);
    }

    public Matrix V() {
        DenseMatrix a2 = this.L ? new CorrelationMatrix((Matrix)new CovarianceMatrix((Matrix)this.X())) : new CovarianceMatrix((Matrix)this.X());
        return this.E != null ? this.E : a2;
    }

    public Eigen eigen() {
        return new Eigen(this.V());
    }

    public PCAbyEigen(Matrix data, boolean correlation) {
        this(data, correlation, null);
    }

    @Override
    public DenseVector sdPrincipalComponent() {
        int a2;
        double[] a3 = this.eigen().getRealEigenvalues();
        int a4 = a3.length;
        double[] a5 = new double[a4];
        int n = a2 = 0;
        while (n < a4) {
            a5[a2] = Math.sqrt(a3[a2]);
            n = ++a2;
        }
        return new DenseVector(a5);
    }

    @Override
    public DenseMatrix loadings() {
        int a2;
        Eigen a3 = this.eigen();
        int a4 = a3.getRealEigenvalues().length;
        DenseMatrix a5 = new DenseMatrix(this.nFactors(), a4);
        int n = a2 = 1;
        while (n <= this.nFactors()) {
            a5.setColumn(a2, a3.getProperty(a2 - 1).eigenVector());
            n = ++a2;
        }
        return a5;
    }

    public PCAbyEigen(Matrix data, boolean correlation, Matrix V) {
        super(data);
        if (V != null) {
            SuanShuUtils.assertArgument(V.nCols() == this.nFactors() && V.nRows() == this.nFactors(), "V is a p*p square matrix, where p is the number of columns of data", new Object[0]);
        }
        this.L = correlation;
        this.E = V != null ? new ImmutableMatrix(V) : null;
    }

    public PCAbyEigen(Matrix data) {
        this(data, true);
    }

    @Override
    public Vector scale() {
        if (this.L) {
            return super.scale();
        }
        return new DenseVector(R.rep(1.0, this.nFactors()));
    }
}

