/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.pca;

import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixMathImpl;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.stats.descriptive.moment.Mean;
import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;
import com.numericalmethod.suanshu.stats.pca.PCA;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public abstract class PCAImpl
implements PCA {
    private final ImmutableMatrix E;

    public PCAImpl(Matrix a2) {
        PCAImpl a3;
        a3.E = new ImmutableMatrix(a2);
    }

    @Override
    public int nObs() {
        return this.E.nRows();
    }

    static {
        Package.getInstance("STATS").isValidated();
    }

    @Override
    public Vector mean() {
        int a2;
        double[] a3 = new double[this.nFactors()];
        int n = a2 = 0;
        while (n < this.nFactors()) {
            a3[a2] = new Mean(this.E.getColumn(a2 + 1).toArray()).value();
            n = ++a2;
        }
        return new DenseVector(a3);
    }

    @Override
    public DenseVector proportionVar() {
        int a2;
        Vector a3 = this.sdPrincipalComponent();
        double a4 = 0.0;
        int a5 = a3.size();
        double[] a6 = new double[a5];
        int n = a2 = 0;
        while (n < a5) {
            a6[a2] = Math.pow(a3.get(a2 + 1), 2.0);
            a4 += a6[a2];
            n = ++a2;
        }
        return new DenseVector(a6).scaled(1.0 / a4);
    }

    public ImmutableMatrix data() {
        return this.E;
    }

    @Override
    public Matrix scores() {
        Matrix a2 = this.loadings();
        return ((MatrixMathImpl)this.X()).multiply(a2);
    }

    @Override
    public DenseVector cumulativeProportionVar() {
        double[] a2 = R.cumsum(this.proportionVar().toArray());
        return new DenseVector(a2);
    }

    @Override
    public Vector scale() {
        int a2;
        double[] a3 = new double[this.nFactors()];
        int n = a2 = 0;
        while (n < this.nFactors()) {
            a3[a2] = Math.sqrt(new Variance(this.E.getColumn(a2 + 1).toArray()).value());
            n = ++a2;
        }
        return new DenseVector(a3);
    }

    @Override
    public double proportionVar(int i2) {
        return this.proportionVar().get(i2);
    }

    @Override
    public DenseMatrix X() {
        int a2;
        Vector a3 = this.mean();
        Vector a4 = this.scale();
        DenseMatrix a5 = new DenseMatrix(this.nObs(), this.nFactors());
        int n = a2 = 1;
        while (n <= this.nFactors()) {
            a5.setColumn(a2, this.data().getColumn(a2).minus(a3.get(a2)).scaled(1.0 / a4.get(a2)));
            n = ++a2;
        }
        return a5;
    }

    @Override
    public double sdPrincipalComponent(int i2) {
        return this.sdPrincipalComponent().get(i2);
    }

    @Override
    public int nFactors() {
        return this.E.nCols();
    }

    @Override
    public Vector loadings(int i2) {
        return this.loadings().getColumn(i2);
    }
}

