/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.markovchain;

import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.RandomNumberGenerator;
import com.numericalmethod.suanshu.stats.random.multivariate.MultinomialRvg;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class SimpleMC
implements RandomNumberGenerator {
    private final ImmutableMatrix F;
    private final ImmutableVector k;
    private int L = -1;
    private MultinomialRvg[] E;

    public ImmutableMatrix A() {
        return this.F;
    }

    public SimpleMC(Vector PI, Matrix A) {
        int a2;
        int a3 = A.nRows();
        SuanShuUtils.assertArgument(PI.size() == a3, "the length of PI should be the same as the number of states", new Object[0]);
        SuanShuUtils.assertArgument(A.nCols() == a3, "A should be a square matrix", new Object[0]);
        this.k = new ImmutableVector(PI);
        this.F = new ImmutableMatrix(A);
        this.E = new MultinomialRvg[1 + A.nRows()];
        this.E[0] = new MultinomialRvg(1, PI.toArray());
        int n = a2 = 1;
        while (n < this.E.length) {
            this.E[a2] = new MultinomialRvg(1, A.getRow(a2).toArray());
            n = ++a2;
        }
    }

    static {
        Package.getInstance("STATS").isValidated();
    }

    public static int bin(MultinomialRvg rvg) {
        double[] a2 = rvg.nextVector();
        int a3 = 1;
        double[] dArray = a2;
        while (true) {
            if (dArray[a3 - 1] != 0.0) break;
            ++a3;
            dArray = a2;
        }
        return a3;
    }

    @Override
    public void seed(long ... seeds) {
        int a2;
        int n = a2 = 0;
        while (n < this.E.length) {
            this.E[a2].seed(seeds);
            n = ++a2;
        }
    }

    public static Vector getStationaryProbabilities(Matrix A) {
        int a2 = A.nRows();
        Matrix a3 = A.t().minus(A.ONE());
        ((DenseMatrix)a3).setRow(a2, R.rep(1.0, a2));
        DenseVector a4 = new DenseVector(a2, 0.0);
        a4.set(a2, 1.0);
        return new Inverse(a3).multiply(a4);
    }

    public SimpleMC(Matrix A) {
        this(SimpleMC.getStationaryProbabilities(A), A);
    }

    public int nextState() {
        int a2;
        MultinomialRvg a3 = this.E[0];
        if (this.L != -1) {
            a3 = this.E[this.L];
        }
        this.L = a2 = SimpleMC.bin(a3);
        return a2;
    }

    public int nStates() {
        return this.F.nRows();
    }

    public ImmutableVector PI() {
        return this.k;
    }

    @Override
    public double nextDouble() {
        return this.nextState();
    }
}

