/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.factoranalysis;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.number.DoubleArrayMath;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.unconstrained.NelderMead;
import com.numericalmethod.suanshu.stats.factoranalysis.FactorAnalysis;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class FactorAnalysisMLE {
    private final ImmutableMatrix F;
    public final RealScalarFunction nL;
    private final int k;
    private final GRADIENT L;
    private final int E;

    public double[] estimate(Vector a2) {
        Vector vector;
        FactorAnalysisMLE a3;
        NelderMead a4 = new NelderMead();
        a4.solve(a3.nL, 0.0, a3.k);
        Vector[] vectorArray = new Vector[1];
        vectorArray[0] = a2;
        Vector a5 = a4.search(vectorArray);
        if (DoubleArrayMath.min(vector.toArray()) < 0.005) {
            throw new RuntimeException("invalid psi");
        }
        return a5.toArray();
    }

    public FactorAnalysisMLE(Matrix a2, int a3) {
        a4(a2, a3, GRADIENT.ANALYTICAL, 50000);
        FactorAnalysisMLE a4;
    }

    public FactorAnalysisMLE(Matrix a2, int a3, GRADIENT a4, int a5) {
        FactorAnalysisMLE a6;
        a6.F = new ImmutableMatrix(a2);
        a6.E = a3;
        a6.L = a4;
        a6.k = a5;
        a6.nL = a6.new logLikelihood(null);
    }

    public static class 1 {
    }

    private class GradientFunction
    implements RealVectorFunction {
        public final int p;

        @Override
        public int dimensionOfDomain() {
            return this.p;
        }

        private GradientFunction() {
            GradientFunction a2;
            a2.p = a2.FactorAnalysisMLE.this.F.nRows();
        }

        @Override
        public int dimensionOfRange() {
            return 1;
        }

        @Override
        public Vector evaluate(double ... psi) {
            int a2;
            Matrix a3 = FactorAnalysis.getLoadings(psi, FactorAnalysisMLE.this.E, FactorAnalysisMLE.this.F);
            DiagonalMatrix a4 = new DiagonalMatrix(psi);
            Inverse a5 = new Inverse(a4);
            Matrix a6 = a3.multiply(a3.t()).add(a4).minus(FactorAnalysisMLE.this.F);
            a6 = a5.multiply(a6).multiply(a5);
            DenseVector a7 = new DenseVector(this.p);
            int n = a2 = 1;
            while (n <= this.p) {
                a7.set(a2, a6.get(a2, a2));
                n = ++a2;
            }
            return a7;
        }
    }

    private class logLikelihood
    implements RealScalarFunction {
        public final int p;

        @Override
        public int dimensionOfDomain() {
            return this.p;
        }

        @Override
        public double evaluate(double ... psi) {
            int a2;
            if (DoubleArrayMath.min(psi) < 0.005) {
                return 1.0E10;
            }
            double a3 = DoubleArrayMath.max(psi);
            if (a3 > 1.0) {
                return 1.0E10;
            }
            DiagonalMatrix a4 = new DiagonalMatrix(DoubleUtils.foreach(psi, new UnivariateRealFunction(){
                {
                    1 a2;
                }

                @Override
                public double evaluate(double psi) {
                    return 1.0 / Math.sqrt(psi);
                }
            }));
            Matrix a5 = a4.multiply(FactorAnalysisMLE.this.F).multiply(a4);
            Eigen a6 = new Eigen(a5);
            double[] a7 = Arrays.copyOfRange(a6.getRealEigenvalues(), FactorAnalysisMLE.this.E, this.p);
            double a8 = 0.0;
            int n = a2 = 0;
            while (n < this.p - FactorAnalysisMLE.this.E) {
                a8 += a7[a2] - Math.log(a7[a2]);
                n = ++a2;
            }
            return a8 -= (double)(this.p - FactorAnalysisMLE.this.E);
        }

        @Override
        public int dimensionOfRange() {
            return 1;
        }

        private logLikelihood() {
            logLikelihood a2;
            a2.p = a2.FactorAnalysisMLE.this.F.nRows();
        }

        public /* synthetic */ logLikelihood(com.numericalmethod.suanshu.stats.factoranalysis.FactorAnalysisMLE$1 a3) {
            a4();
            logLikelihood a4;
        }
    }

    public static final class GRADIENT
    extends Enum<GRADIENT> {
        public static final /* enum */ GRADIENT ANALYTICAL = new GRADIENT();
        private static final /* synthetic */ GRADIENT[] E;
        public static final /* enum */ GRADIENT NUMERICAL = new GRADIENT();

        public static GRADIENT valueOf(String name) {
            return Enum.valueOf(GRADIENT.class, name);
        }

        static {
            GRADIENT[] gRADIENTArray = new GRADIENT[2];
            gRADIENTArray[0] = ANALYTICAL;
            gRADIENTArray[1] = NUMERICAL;
            E = gRADIENTArray;
        }

        public static GRADIENT[] values() {
            return (GRADIENT[])E.clone();
        }

        private GRADIENT() {
            GRADIENT a2;
        }
    }
}

