/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.factoranalysis;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.matrix.doubles.factorization.svd.SVD;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixMathImpl;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixStorageImpl;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.number.DoubleArrayMath;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.descriptive.CorrelationMatrix;
import com.numericalmethod.suanshu.stats.descriptive.CovarianceMatrix;
import com.numericalmethod.suanshu.stats.descriptive.moment.Mean;
import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;
import com.numericalmethod.suanshu.stats.factoranalysis.FAEstimator;
import com.numericalmethod.suanshu.stats.factoranalysis.FactorAnalysisMLE;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class FactorAnalysis {
    private final ImmutableMatrix F;
    private final ImmutableMatrix k;
    private final Scores L;
    private final int E;

    public FAEstimator getEstimates(Vector initial, int maxIterations) {
        int a2;
        FactorAnalysisMLE a3 = new FactorAnalysisMLE(this.corr(), this.E, FactorAnalysisMLE.GRADIENT.NUMERICAL, maxIterations);
        double[] a4 = a3.estimate(initial);
        Matrix a5 = FactorAnalysis.getRotatedLoadings(FactorAnalysis.getLoadings(a4, this.E, this.k), true, 1.0E-5);
        int n = a2 = 1;
        while (n <= a5.nCols()) {
            int a6;
            double a7 = 0.0;
            int n2 = a6 = 1;
            while (n2 <= a5.nRows()) {
                a7 += a5.get(a6, a2);
                n2 = ++a6;
            }
            if (a7 < 0.0) {
                ((DenseMatrix)a5).setColumn(a2, a5.getColumn(a2).scaled(-1.0));
            }
            n = ++a2;
        }
        double a22 = a3.nL.evaluate(a4);
        int a8 = this.nVariables() - this.E;
        a8 *= a8;
        a8 -= this.nVariables() + this.E;
        Matrix a9 = this.b(this.F, this.k, a4, a5, this.L);
        return new FAEstimator(this.nObs(), a4, a5, a22, a8 /= 2, a9);
    }

    public int nObs() {
        return this.F.nRows();
    }

    public static Matrix getLoadings(double[] a2, int a3, Matrix a4) {
        int a5;
        int a6 = a4.nRows();
        DiagonalMatrix a7 = new DiagonalMatrix(DoubleUtils.foreach(a2, new UnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double psi) {
                return Math.sqrt(psi);
            }
        }));
        DiagonalMatrix a8 = new DiagonalMatrix(DoubleUtils.foreach(a2, new UnivariateRealFunction(){
            {
                2 a2;
            }

            @Override
            public double evaluate(double psi) {
                return 1.0 / Math.sqrt(psi);
            }
        }));
        Matrix a9 = a8.multiply(a4).multiply(a8);
        Eigen a10 = new Eigen(a9);
        double[] a11 = Arrays.copyOfRange(a10.getRealEigenvalues(), 0, a3);
        DiagonalMatrix a12 = new DiagonalMatrix(DoubleUtils.foreach(a11, new UnivariateRealFunction(){
            {
                3 a2;
            }

            @Override
            public double evaluate(double theta) {
                return Math.sqrt(Math.max(theta - 1.0, 0.0));
            }
        }));
        DenseMatrix a13 = new DenseMatrix(a6, a3);
        int n = a5 = 1;
        while (n <= a3) {
            a13.setColumn(a5, a10.getProperty(a5 - 1).eigenVector());
            n = ++a5;
        }
        Matrix a22 = a7.multiply(a13).multiply(a12);
        return a22;
    }

    public int nFactors() {
        return this.E;
    }

    public FactorAnalysis(Matrix data, int nFactors, Scores scoresType, Matrix S) {
        this.F = new ImmutableMatrix(data);
        this.E = nFactors;
        this.L = scoresType;
        this.k = new ImmutableMatrix(S);
    }

    public FactorAnalysis(Matrix data, int nFactors, Scores scoresType) {
        this(data, nFactors, scoresType, new CorrelationMatrix((Matrix)new CovarianceMatrix(data)));
    }

    public int nVariables() {
        return this.k.nRows();
    }

    private Matrix b(Matrix a2, Matrix a3, double[] a4, Matrix a5, Scores a6) {
        Matrix a7;
        Object a8;
        int a9;
        int a10 = a2.nCols();
        DenseMatrix a11 = new DenseMatrix(a2);
        int n = a9 = 1;
        while (n <= a10) {
            a8 = a11.getColumn(a9).toArray();
            double a12 = new Mean((double[])a8).value();
            double a13 = new Variance((double[])a8).standardDeviation();
            a11.setColumn(a9, a11.getColumn(a9).minus(a12).scaled(1.0 / a13));
            n = ++a9;
        }
        switch (a6) {
            case THOMSON: {
                a8 = new Inverse(a3).multiply(a5);
                a7 = a11.multiply((Matrix)a8);
                break;
            }
            case BARTLETT: {
                int a14;
                do {
                } while (false);
                a8 = new DenseMatrix(a5.nRows(), a5.nCols());
                int n2 = a14 = 1;
                while (n2 <= a5.nRows()) {
                    int a15;
                    int n3 = a15 = 1;
                    while (n3 <= a5.nCols()) {
                        ((MatrixStorageImpl)a8).set(a14, a15, a5.get(a14, a15) / a4[a14 - 1]);
                        n3 = ++a15;
                    }
                    n2 = ++a14;
                }
                a8 = ((DenseMatrix)a8).t();
                a7 = new Inverse(((MatrixMathImpl)a8).multiply(a5)).multiply(((DenseMatrix)a8).multiply(a11.t())).t();
                break;
            }
            default: {
                throw new UnsupportedOperationException("");
            }
        }
        return a7;
    }

    public Scores scoreType() {
        return this.L;
    }

    public FactorAnalysis(Matrix data, int nFactors) {
        this(data, nFactors, Scores.BARTLETT, new CorrelationMatrix((Matrix)new CovarianceMatrix(data)));
    }

    public FAEstimator getEstimates(int maxIterations) {
        return this.getEstimates(this.b(), maxIterations);
    }

    public static Matrix getRotatedLoadings(Matrix a2, boolean a3, double a4) {
        if (a2.nCols() < 2) {
            return a2;
        }
        Matrix a5 = FactorAnalysis.varimaxRotation(a2, a3, a4);
        return a2.multiply(a5);
    }

    public ImmutableMatrix corr() {
        return this.k;
    }

    private Vector b() {
        int a2;
        FactorAnalysis a3;
        int a4 = a3.nVariables();
        double a5 = 1.0 - 0.5 * (double)a3.E / (double)a4;
        Inverse a6 = new Inverse(a3.k);
        DenseVector a7 = new DenseVector(a4);
        int n = a2 = 1;
        while (n <= a4) {
            a7.set(a2, a5 / a6.get(a2, a2));
            n = ++a2;
        }
        return a7;
    }

    public static Matrix varimaxRotation(Matrix a2, boolean a3, double a4) {
        int a5 = a2.nRows();
        int a6 = a2.nCols();
        if (a6 < 2) {
            double[] dArray = new double[1];
            dArray[0] = 1.0;
            return new DenseMatrix(dArray, 1, 1);
        }
        DenseMatrix a7 = new DenseMatrix(a2);
        double[] a8 = R.rep(1.0, a5);
        if (a3) {
            int a9;
            int n = a9 = 1;
            while (n <= a5) {
                a8[a9 - 1] = a7.getRow(a9).norm();
                a7.setRow(a9, a7.getRow(a9).scaled(1.0 / a8[a9 - 1]));
                n = ++a9;
            }
        }
        Matrix a10 = new DiagonalMatrix(R.rep(1.0, a6));
        double a11 = 0.0;
        double a12 = 0.0;
        while (true) {
            double d2;
            int a13;
            int a14;
            Matrix a15 = a7.multiply(a10);
            DenseMatrix a16 = new DenseMatrix(a5, a6);
            int n = a14 = 1;
            while (n <= a5) {
                int n2 = a13 = 1;
                while (n2 <= a6) {
                    a16.set(a14, a13, Math.pow(a15.get(a14, a13), 3.0));
                    n2 = ++a13;
                }
                n = ++a14;
            }
            double[] a22 = new double[a6];
            int n3 = a13 = 0;
            while (n3 < a6) {
                a22[a13] = a15.getColumn(a13 + 1).norm();
                int n4 = a13;
                a22[n4] = a22[n4] * a22[a13];
                n3 = ++a13;
            }
            DiagonalMatrix a32 = new DiagonalMatrix(a22);
            Matrix a17 = a7.t().multiply(a16.minus(a15.multiply(a32).scaled(1.0 / (double)a5)));
            SVD a18 = new SVD(a17, true);
            a10 = a18.U().multiply(a18.V().t());
            a12 = DoubleArrayMath.sum(MatrixUtils.to1DArray(a18.D()));
            if (d2 < a11 * (1.0 + a4)) break;
            a11 = a12;
        }
        return a10;
    }

    public static final class Scores
    extends Enum<Scores> {
        public static final /* enum */ Scores BARTLETT;
        public static final /* enum */ Scores THOMSON;
        private static final /* synthetic */ Scores[] E;

        private Scores() {
            Scores a2;
        }

        public static Scores valueOf(String name) {
            return Enum.valueOf(Scores.class, name);
        }

        public static Scores[] values() {
            return (Scores[])E.clone();
        }

        static {
            THOMSON = new Scores();
            BARTLETT = new Scores();
            Scores[] scoresArray = new Scores[2];
            scoresArray[0] = THOMSON;
            scoresArray[1] = BARTLETT;
            E = scoresArray;
        }
    }
}

