/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.factoranalysis;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.stats.distribution.univariate.ChiSquareDistribution;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class FAEstimator
extends HypothesisTest {
    private final ImmutableVector i;
    private final ImmutableMatrix G;
    private final int F;
    private final double k;
    private final int L;
    private final ImmutableMatrix E;

    public ImmutableMatrix scores() {
        return this.E;
    }

    public double logLikelihood() {
        return this.k;
    }

    public ImmutableMatrix loadings() {
        return this.G;
    }

    @Override
    public double pValue() {
        this.testStatistics = this.statistics();
        if (this.L <= 0) {
            return -1.0;
        }
        ChiSquareDistribution a2 = new ChiSquareDistribution(this.L);
        return 1.0 - a2.cdf(this.testStatistics);
    }

    @Override
    public double statistics() {
        int a2 = this.G.nRows();
        int a3 = this.G.nCols();
        double a4 = this.F;
        a4 -= 1.0;
        a4 -= (2.0 * (double)a2 + 5.0) / 6.0;
        a4 -= 2.0 * (double)a3 / 3.0;
        return a4 *= this.k;
    }

    public int dof() {
        return this.L;
    }

    public FAEstimator(int a2, double[] a3, Matrix a4, double a5, int a6, Matrix a7) {
        super(new double[0][]);
        FAEstimator a8;
        a8.F = a2;
        a8.i = new ImmutableVector(new DenseVector(a3));
        a8.G = new ImmutableMatrix(a4);
        a8.k = a5;
        a8.L = a6;
        a8.E = new ImmutableMatrix(a7);
    }

    public ImmutableVector psi() {
        return this.i;
    }

    @Override
    public String getNullHypothesis() {
        Object[] objectArray = new Object[1];
        objectArray[0] = this.G.nCols();
        return String.format("There are at least %d factors.", objectArray);
    }

    @Override
    public String getAlternativeHypothesis() {
        Object[] objectArray = new Object[1];
        objectArray[0] = this.G.nCols();
        return String.format("There are less than %d factors.", objectArray);
    }
}

