/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm.univariate;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.univariate.normal.NormalRng;

public class ObservationEquation {
    private final UnivariateRealFunction k;
    private final UnivariateRealFunction L;
    private final NormalRng E;

    public ObservationEquation(UnivariateRealFunction F2, UnivariateRealFunction V, NormalRng rnorm) {
        SuanShuUtils.assertArgument(F2.dimensionOfDomain() == V.dimensionOfDomain(), "the domain dimensions of F and V must match", new Object[0]);
        this.L = F2;
        this.k = V;
        this.E = rnorm;
    }

    public double F(int t) {
        return this.L.evaluate((double)t);
    }

    public ObservationEquation(UnivariateRealFunction F2, UnivariateRealFunction V) {
        this(F2, V, new NormalRng(0.0, 1.0));
    }

    public ObservationEquation(double F2, double V) {
        this(F2, V, new NormalRng(0.0, 1.0));
    }

    public ObservationEquation(final double F2, final double V, NormalRng rnorm) {
        this(new UnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double x) {
                return F2;
            }
        }, new UnivariateRealFunction(){
            {
                2 a2;
            }

            @Override
            public double evaluate(double x) {
                return V;
            }
        }, rnorm);
    }

    public double V(int t) {
        return this.k.evaluate((double)t);
    }

    public double yt_mean(int t, double xt) {
        return this.L.evaluate((double)t) * xt;
    }

    public ObservationEquation(ObservationEquation that) {
        this(that.L, that.k);
    }

    public int dimension() {
        return 1;
    }

    public double yt(int t, double xt) {
        double a2 = this.yt_mean(t, xt);
        double a3 = this.E.nextDouble() * Math.sqrt(this.k.evaluate((double)t));
        return a2 += a3;
    }

    public double yt_var(int t, double var_t_tlag) {
        double a2 = this.F(t);
        double a3 = this.V(t);
        return a2 * var_t_tlag * a2 + a3;
    }
}

