/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm.univariate;

import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.stats.dlm.univariate.DLM;
import com.numericalmethod.suanshu.stats.dlm.univariate.ObservationEquation;
import com.numericalmethod.suanshu.stats.dlm.univariate.StateEquation;
import java.util.Arrays;

public class LinearKalmanFilter {
    private double[] f;
    private final DLM M;
    private double[] i;
    private double[] G;
    private double[] F;
    private double[] k;
    private double[] L;
    private double[] E;

    public void filtering(double[] Y, double[] U) {
        int a2;
        StateEquation a3 = this.M.getStateModel();
        ObservationEquation a4 = this.M.getObservationModel();
        int a5 = Y.length;
        this.G = new double[a5];
        this.i = new double[a5];
        this.L = new double[a5];
        this.E = new double[a5];
        this.f = new double[a5];
        this.k = new double[a5];
        this.F = new double[a5];
        int n = a2 = 0;
        while (n < a5) {
            double a6;
            double a7;
            double a8;
            double a9;
            double a10;
            double a11;
            double a12 = a2 > 0 ? this.k[a2 - 1] : this.M.m0();
            this.G[a2] = a11 = a3.xt_mean(a2, a12, U[a2]);
            double a13 = a2 > 0 ? this.F[a2 - 1] : this.M.C0();
            this.i[a2] = a10 = a3.xt_var(a2, a13);
            this.L[a2] = a9 = a4.yt_mean(a2, a11);
            this.E[a2] = a8 = a4.yt_var(a2, a10);
            double a14 = a4.F(a2);
            this.f[a2] = a10 * a14 / a8;
            double a15 = Y[a2] - a9;
            this.k[a2] = a7 = a11 + this.f[a2] * a15;
            this.F[a2] = a6 = a10 - this.f[a2] * a14 * a10;
            n = ++a2;
        }
    }

    public double[] getFittedStates() {
        return Arrays.copyOf(this.k, this.k.length);
    }

    public double getPredictedState(int t) {
        return this.G[t - 1];
    }

    public double getPredictedObservation(int t) {
        return this.L[t - 1];
    }

    public double getKalmanGain(int t) {
        return this.f[t - 1];
    }

    public double getFittedState(int t) {
        return this.k[t - 1];
    }

    public int dimension() {
        return 1;
    }

    public double getPredictedStateVariance(int t) {
        return this.i[t - 1];
    }

    public double getFittedStateVariance(int t) {
        return this.F[t - 1];
    }

    public LinearKalmanFilter(DLM model) {
        this.M = model;
    }

    public void filtering(double[] Y) {
        this.filtering(Y, R.rep(0.0, Y.length));
    }

    public double[] getPredictedObservations() {
        return Arrays.copyOf(this.L, this.L.length);
    }

    public double getPredictedObservationVariance(int t) {
        return this.E[t - 1];
    }

    public int size() {
        return this.k.length;
    }

    public double[] getPredictedStates() {
        return Arrays.copyOf(this.G, this.G.length);
    }
}

