/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm.multivariate;

import com.numericalmethod.suanshu.analysis.function.matrix.R1toConstantMatrix;
import com.numericalmethod.suanshu.analysis.function.matrix.R1toMatrix;
import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.multivariate.NormalRvg;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class StateEquation {
    private final R1toMatrix G;
    private final R1toMatrix F;
    private final int k;
    private final R1toMatrix L;
    private final NormalRvg E;

    public StateEquation(Matrix G, Matrix H, Matrix W, NormalRvg rmvnorm) {
        this(new R1toConstantMatrix(G), H != null ? new R1toConstantMatrix(H) : null, new R1toConstantMatrix(W), rmvnorm);
    }

    public StateEquation(StateEquation that) {
        this(that.F, that.G, that.L);
    }

    public Matrix W(int t) {
        return this.L.evaluate((double)t);
    }

    public StateEquation(Matrix G, Matrix W) {
        this(G, null, W, null);
    }

    public StateEquation(R1toMatrix G, R1toMatrix W) {
        this(G, null, W);
    }

    public StateEquation(final com.numericalmethod.suanshu.stats.dlm.univariate.StateEquation states) {
        this(new R1toMatrix(){
            {
                1 a2;
            }

            @Override
            public Matrix evaluate(double t) {
                double[][] dArrayArray = new double[1][];
                double[] dArray = new double[1];
                dArray[0] = states.G((int)t);
                dArrayArray[0] = dArray;
                return new DenseMatrix(dArrayArray);
            }
        }, new R1toMatrix(){
            {
                2 a2;
            }

            @Override
            public Matrix evaluate(double t) {
                double[][] dArrayArray = new double[1][];
                double[] dArray = new double[1];
                dArray[0] = states.H((int)t);
                dArrayArray[0] = dArray;
                return new DenseMatrix(dArrayArray);
            }
        }, new R1toMatrix(){
            {
                3 a2;
            }

            @Override
            public Matrix evaluate(double t) {
                double[][] dArrayArray = new double[1][];
                double[] dArray = new double[1];
                dArray[0] = states.W((int)t);
                dArrayArray[0] = dArray;
                return new DenseMatrix(dArrayArray);
            }
        });
    }

    public Matrix xt_var(int t, Matrix var_tlag_tlag) {
        Matrix a2 = this.G(t);
        Matrix a3 = this.W(t);
        return a2.multiply(var_tlag_tlag).multiply(a2.t()).add(a3);
    }

    public Matrix G(int t) {
        return this.F.evaluate((double)t);
    }

    static {
        Package.getInstance("STATS").isValidated();
    }

    public Vector xt(int t, Vector xt_1, Vector ut) {
        Vector a2 = this.xt_mean(t, xt_1, ut);
        Matrix a3 = this.L.evaluate((double)t);
        Vector a4 = NormalRvg.modifiedCholeskyWang2006(a3, SuanShuUtils.autoEpsilon(MatrixUtils.to1DArray(a3))).multiply(new DenseVector(this.E.nextVector()));
        a2 = a2.add(a4);
        return a2;
    }

    public int dimension() {
        return this.k;
    }

    public Vector xt_mean(int t, Vector xt_1) {
        return this.xt_mean(t, xt_1, null);
    }

    public StateEquation(R1toMatrix G, R1toMatrix H, R1toMatrix W) {
        this(G, H, W, null);
    }

    public Vector xt_mean(int t, Vector xt_1, Vector ut) {
        Vector a2 = this.F.evaluate((double)t).multiply(xt_1);
        if (this.G != null) {
            Vector a3 = this.G.evaluate((double)t).multiply(ut);
            a2 = a2.add(a3);
        }
        return a2;
    }

    public Vector xt(int t, Vector xt_1) {
        SuanShuUtils.assertArgument(this.G == null, "H is not null and thus it requires the control variable", new Object[0]);
        return this.xt(t, xt_1, null);
    }

    public StateEquation(R1toMatrix G, R1toMatrix H, R1toMatrix W, NormalRvg rmvnorm) {
        this.k = G.evaluate(1.0).nRows();
        SuanShuUtils.assertArgument(W.evaluate(1.0).nRows() == this.k && W.evaluate(1.0).nCols() == this.k, "the dimension of W is the dimension of each state x_t", new Object[0]);
        if (H != null) {
            SuanShuUtils.assertArgument(H.evaluate(1.0).nRows() == this.k, "the dimension of W is the dimension of each state x_t", new Object[0]);
        }
        this.F = G;
        this.G = H;
        this.L = W;
        this.E = rmvnorm == null ? new NormalRvg(this.k) : rmvnorm;
    }

    public Matrix H(int t) {
        return this.G != null ? this.G.evaluate((double)t) : null;
    }
}

