/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm.multivariate;

import com.numericalmethod.suanshu.analysis.function.matrix.R1toConstantMatrix;
import com.numericalmethod.suanshu.analysis.function.matrix.R1toMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.multivariate.NormalRvg;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class ObservationEquation {
    private final int F;
    private final R1toMatrix k;
    private final NormalRvg L;
    private final R1toMatrix E;

    public Matrix F(int t) {
        return this.k.evaluate((double)t);
    }

    public ObservationEquation(R1toMatrix F2, R1toMatrix V, NormalRvg rmvnorm) {
        this.F = F2.evaluate(1.0).nRows();
        SuanShuUtils.assertArgument(V.evaluate(1.0).nRows() == this.F && V.evaluate(1.0).nCols() == this.F, "the dimension of V is the dimension of each observation y_t", new Object[0]);
        this.k = F2;
        this.E = V;
        this.L = rmvnorm == null ? new NormalRvg(this.F) : rmvnorm;
    }

    public ObservationEquation(Matrix F2, Matrix V) {
        this(new R1toConstantMatrix(F2), new R1toConstantMatrix(V), null);
    }

    public Vector yt_mean(int t, Vector xt) {
        return this.k.evaluate((double)t).multiply(xt);
    }

    public ObservationEquation(Matrix F2, Matrix V, NormalRvg rmvnorm) {
        this(new R1toConstantMatrix(F2), new R1toConstantMatrix(V), rmvnorm);
    }

    public ObservationEquation(R1toMatrix F2, R1toMatrix V) {
        this(F2, V, null);
    }

    public Matrix V(int t) {
        return this.E.evaluate((double)t);
    }

    public Vector yt(int t, Vector xt) {
        Vector a2 = this.yt_mean(t, xt);
        Matrix a3 = this.E.evaluate((double)t);
        Vector a4 = NormalRvg.modifiedCholeskyWang2006(a3, SuanShuUtils.autoEpsilon(MatrixUtils.to1DArray(a3))).multiply(new DenseVector(this.L.nextVector()));
        a2 = a2.add(a4);
        return a2;
    }

    public Matrix yt_var(int t, Matrix var_t_tlag) {
        Matrix a2 = this.F(t);
        Matrix a3 = this.V(t);
        return a2.multiply(var_t_tlag).multiply(a2.t()).add(a3);
    }

    public int dimension() {
        return this.F;
    }

    public ObservationEquation(ObservationEquation that) {
        this(that.k, that.E);
    }

    public ObservationEquation(final com.numericalmethod.suanshu.stats.dlm.univariate.ObservationEquation obs) {
        this(new R1toMatrix(){
            {
                1 a2;
            }

            @Override
            public Matrix evaluate(double t) {
                double[][] dArrayArray = new double[1][];
                double[] dArray = new double[1];
                dArray[0] = obs.F((int)t);
                dArrayArray[0] = dArray;
                return new DenseMatrix(dArrayArray);
            }
        }, new R1toMatrix(){
            {
                2 a2;
            }

            @Override
            public Matrix evaluate(double t) {
                double[][] dArrayArray = new double[1][];
                double[] dArray = new double[1];
                dArray[0] = obs.V((int)t);
                dArrayArray[0] = dArray;
                return new DenseMatrix(dArrayArray);
            }
        });
    }
}

