/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm.multivariate;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.stats.dlm.multivariate.DLM;
import com.numericalmethod.suanshu.stats.dlm.multivariate.ObservationEquation;
import com.numericalmethod.suanshu.stats.dlm.multivariate.StateEquation;
import com.numericalmethod.suanshu.stats.random.multivariate.NormalRvg;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime.MultiVariateTimeSeries;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime.SimpleMultiVariateTimeSeries;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class DLMSim {
    private final Matrix k;
    private final Matrix L;
    private final NormalRvg E;

    public DLMSim(int T2, DLM model) {
        this(T2, model, null);
    }

    public SimpleMultiVariateTimeSeries getObservations() {
        return new SimpleMultiVariateTimeSeries(this.k);
    }

    public DLMSim(int T2, DLM model, MultiVariateTimeSeries Ut, NormalRvg rmvnorm) {
        this.E = rmvnorm;
        this.L = this.b(T2, model, Ut);
        this.k = this.b(this.L, model);
    }

    public DLMSim(int T2, DLM model, MultiVariateTimeSeries Ut) {
        this(T2, model, Ut, new NormalRvg(model.stateDimension()));
    }

    private DenseMatrix b(Matrix a2, DLM a3) {
        int a4;
        ObservationEquation a5 = a3.getObservationModel();
        int a6 = a2.nRows();
        int a7 = a3.obsDimension();
        DenseMatrix a8 = new DenseMatrix(a6, a7);
        int n = a4 = 1;
        while (n <= a6) {
            Vector a9 = a5.yt(a4, a2.getRow(a4));
            a8.setRow(a4, a9);
            n = ++a4;
        }
        return a8;
    }

    public SimpleMultiVariateTimeSeries getStates() {
        return new SimpleMultiVariateTimeSeries(this.L);
    }

    private Matrix b(int a2, DLM a3, MultiVariateTimeSeries a4) {
        int a5;
        DLMSim a6;
        StateEquation a7 = a3.getStateModel();
        int a8 = a3.stateDimension();
        DenseMatrix a9 = new DenseMatrix(a2, a8);
        ImmutableMatrix a10 = NormalRvg.modifiedCholeskyWang2006(a3.C0(), a8);
        Vector a11 = a3.m0().add(a10.multiply(new DenseVector(a6.E.nextVector())));
        Vector a12 = a7.xt(1, a11, a4 != null ? a4.get(1) : null);
        a9.setRow(1, a12);
        int n = a5 = 2;
        while (n <= a2) {
            a12 = a7.xt(a5, a9.getRow(a5 - 1), a4 != null ? a4.get(a5) : null);
            a9.setRow(a5, a12);
            n = ++a5;
        }
        return a9;
    }
}

