/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm.multivariate;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.dlm.multivariate.ObservationEquation;
import com.numericalmethod.suanshu.stats.dlm.multivariate.StateEquation;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class DLM {
    private final ImmutableVector F;
    private final StateEquation k;
    private final ObservationEquation L;
    public final int p;
    public final int d;
    private final ImmutableMatrix E;

    public int stateDimension() {
        return this.p;
    }

    public DLM(Vector m0, Matrix C0, ObservationEquation Yt, StateEquation Xt) {
        SuanShuUtils.assertArgument(m0 != null && C0 != null, "the distribution of the initial state x_0 ~ N(m0, C0) must be specified", new Object[0]);
        this.p = m0.size();
        this.d = Yt.dimension();
        this.F = new ImmutableVector(m0);
        SuanShuUtils.assertArgument(C0.nRows() == this.p && C0.nCols() == this.p, "the dimension of C0 is p x p", new Object[0]);
        this.E = new ImmutableMatrix(C0);
        SuanShuUtils.assertArgument(Yt.dimension() == this.d, "the dimension of the observation equation is d", new Object[0]);
        SuanShuUtils.assertArgument(Yt.F(1).nCols() == this.p, "the dimension of F is d x p", new Object[0]);
        this.L = Yt;
        SuanShuUtils.assertArgument(Xt.dimension() == this.p, "the dimension of the state equation is p", new Object[0]);
        this.k = Xt;
    }

    public ObservationEquation getObservationModel() {
        return this.L;
    }

    public DLM(DLM that) {
        this(that.F, that.E, that.L, that.k);
    }

    public int obsDimension() {
        return this.d;
    }

    public StateEquation getStateModel() {
        return this.k;
    }

    public ImmutableVector m0() {
        return this.F;
    }

    public ImmutableMatrix C0() {
        return this.E;
    }
}

