/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.sequence.Summation;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class PoissonDistribution
implements UnivariateDistribution {
    public final double lambda;

    @Override
    public double moment(double t) {
        double a2 = Math.exp(t) - 1.0;
        a2 *= this.lambda;
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double mean() {
        return this.lambda;
    }

    public PoissonDistribution(double lambda) {
        SuanShuUtils.assertArgument(lambda > 0.0, "lambda must be > 0", new Object[0]);
        this.lambda = lambda;
    }

    @Override
    public double density(double k) {
        int a2;
        assert (k >= 0.0) : "x must be >= 0";
        double a3 = Math.exp(-this.lambda);
        int n = a2 = 1;
        while (n <= (int)k) {
            a3 *= this.lambda / (double)a2;
            n = ++a2;
        }
        return a3;
    }

    public double entropy1() {
        double a2 = this.lambda * (1.0 - Math.log(this.lambda));
        double a3 = new Summation(new Summation.Term(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double k) {
                int a2;
                int a3;
                double a4 = 1.0;
                int n = a3 = 1;
                while ((double)n <= k) {
                    a4 *= PoissonDistribution.this.lambda / (double)a3;
                    n = ++a3;
                }
                double a22 = 0.0;
                int n2 = a2 = 1;
                while ((double)n2 <= k) {
                    a22 += Math.log(a2);
                    n2 = ++a2;
                }
                return a4 * a22;
            }
        }, 1.0E-8).sumToInfinity(2.0, 1.0);
        return a2 += Math.exp(-this.lambda) * a3;
    }

    @Override
    public double variance() {
        return this.lambda;
    }

    @Override
    public double kurtosis() {
        return 1.0 / this.lambda;
    }

    public double ccdf(double x) {
        return 1.0 - this.cdf(x);
    }

    @Override
    public double quantile(double u) {
        int a2 = 0;
        while (!(this.cdf(a2) >= u)) {
            ++a2;
        }
        return a2;
    }

    public double entropy2() {
        double a2 = 0.5 * Math.log(Math.PI * 2 * Math.exp(1.0) * this.lambda);
        a2 -= 0.08333333333333333 / this.lambda;
        a2 -= 0.041666666666666664 / this.lambda / this.lambda;
        return a2 -= 0.05277777777777778 / this.lambda / this.lambda / this.lambda;
    }

    @Override
    public double median() {
        return (int)(this.lambda + 0.3333333333333333 - 0.02 * this.lambda);
    }

    @Override
    public double cdf(double k) {
        int a2;
        double a3 = 0.0;
        double a4 = 1.0;
        a3 += a4;
        int n = a2 = 1;
        while ((double)n <= k) {
            a3 += (a4 *= this.lambda / (double)a2);
            n = ++a2;
        }
        return a3 *= Math.exp(-this.lambda);
    }

    @Override
    public double skew() {
        return 1.0 / Math.sqrt(this.lambda);
    }

    @Override
    public double entropy() {
        if (this.lambda < 10.0) {
            return this.entropy1();
        }
        return this.entropy2();
    }
}

