/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.CumulativeNormal;
import com.numericalmethod.suanshu.analysis.function.special.CumulativeNormalInverse;
import com.numericalmethod.suanshu.analysis.function.special.Gaussian;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class NormalDistribution
implements UnivariateDistribution {
    private static CumulativeNormal k;
    public final double sigma;
    private static CumulativeNormalInverse L;
    public final double mu;
    private static Gaussian E;

    @Override
    public double mean() {
        return this.mu;
    }

    @Override
    public double entropy() {
        return Math.log(Math.PI * 2 * this.sigma * this.sigma * Math.E);
    }

    @Override
    public double skew() {
        return 0.0;
    }

    @Override
    public double variance() {
        return this.sigma * this.sigma;
    }

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    static {
        E = new Gaussian();
        k = new CumulativeNormal();
        L = new CumulativeNormalInverse();
    }

    @Override
    public double density(double x) {
        double a2 = (x - this.mu) / this.sigma;
        double a3 = E.evaluate(a2);
        return a3 /= this.sigma;
    }

    @Override
    public double moment(double t) {
        double a2 = this.mu * t;
        a2 += 0.5 * this.sigma * this.sigma * t * t;
        a2 = Math.exp(a2);
        return a2;
    }

    public NormalDistribution(double mu, double sigma) {
        this.mu = mu;
        this.sigma = sigma;
    }

    @Override
    public double quantile(double u) {
        double a2 = L.evaluate(u);
        a2 = this.mu + this.sigma * a2;
        return a2;
    }

    @Override
    public double median() {
        return this.mu;
    }

    @Override
    public double cdf(double x) {
        double a2 = (x - this.mu) / this.sigma;
        return k.evaluate(a2);
    }

    @Override
    public double kurtosis() {
        return 0.0;
    }
}

