/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.GammaRegularizedP;
import com.numericalmethod.suanshu.analysis.function.special.GammaRegularizedPInverse;
import com.numericalmethod.suanshu.analysis.function.special.LogGamma;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GammaDistribution
implements UnivariateDistribution {
    private static final GammaRegularizedPInverse k;
    public final double theta;
    public final double k;
    private static final GammaRegularizedP L;
    private static final LogGamma E;

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be non-negative";
        return L.evaluate(this.k, x / this.theta);
    }

    @Override
    public double skew() {
        return 2.0 / Math.sqrt(this.k);
    }

    @Override
    public double variance() {
        return this.k * this.theta * this.theta;
    }

    @Override
    public double kurtosis() {
        return 6.0 / this.k;
    }

    @Override
    public double moment(double t) {
        SuanShuUtils.assertArgument(t < 1.0 / this.theta, "only for t < 1/theta", new Object[0]);
        return Math.pow(1.0 - this.theta * t, -this.k);
    }

    @Override
    public double median() {
        throw new UnsupportedOperationException("There is no simple closed form.");
    }

    public GammaDistribution(double k, double theta) {
        SuanShuUtils.assertArgument(k > 0.0, "k must be > 0", new Object[0]);
        SuanShuUtils.assertArgument(theta > 0.0, "theta must be > 0", new Object[0]);
        this.k = k;
        this.theta = theta;
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (DoubleUtils.compare(x, 0.0) == 0 && this.k < 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (DoubleUtils.compare(x, 0.0) == 0 && this.k == 1.0) {
            return Math.exp(-E.evaluate(this.k) - this.k * Math.log(this.theta));
        }
        double a2 = (this.k - 1.0) * Math.log(x) - x / this.theta - this.k * Math.log(this.theta) - E.evaluate(this.k);
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double mean() {
        return this.k * this.theta;
    }

    static {
        E = new LogGamma();
        L = new GammaRegularizedP();
        k = new GammaRegularizedPInverse();
    }

    @Override
    public double quantile(double u) {
        return this.theta * k.evaluate(this.k, u);
    }

    @Override
    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

