/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class ExponentialDistribution
implements UnivariateDistribution {
    public final double lambda;

    public ExponentialDistribution(double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda > 0");
        }
        this.lambda = lambda;
    }

    @Override
    public double mean() {
        return 1.0 / this.lambda;
    }

    @Override
    public double moment(double t) {
        double a2 = 1.0 - t / this.lambda;
        a2 = 1.0 / a2;
        return a2;
    }

    @Override
    public double skew() {
        return 2.0;
    }

    @Override
    public double density(double x) {
        double a2 = x < 0.0 ? 0.0 : this.lambda * Math.exp(-this.lambda * x);
        return a2;
    }

    public ExponentialDistribution() {
        this(1.0);
    }

    @Override
    public double entropy() {
        return 1.0 - Math.log(this.lambda);
    }

    @Override
    public double kurtosis() {
        return 6.0;
    }

    @Override
    public double quantile(double u) {
        return -Math.log(1.0 - u) / this.lambda;
    }

    @Override
    public double median() {
        return Math.log(2.0) / this.lambda;
    }

    @Override
    public double variance() {
        return 1.0 / this.lambda / this.lambda;
    }

    @Override
    public double cdf(double x) {
        double a2 = x < 0.0 ? 0.0 : 1.0 - Math.exp(-this.lambda * x);
        return a2;
    }
}

