/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.BetaRegularized;
import com.numericalmethod.suanshu.number.big.BigIntegerUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.NormalDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class BinomialDistribution
implements UnivariateDistribution {
    private final int k;
    private double L;
    private final double E;

    @Override
    public double density(double x) {
        int a2 = (int)x;
        if (a2 <= 0 || a2 > this.k) {
            return 0.0;
        }
        if ((double)a2 != x) {
            return 0.0;
        }
        double a3 = BigIntegerUtils.combination(this.k, a2).doubleValue();
        a3 *= Math.pow(this.E, a2);
        return a3 *= Math.pow(1.0 - this.E, this.k - a2);
    }

    @Override
    public double cdf(double x) {
        int a2 = (int)x;
        if (a2 > this.k) {
            return 1.0;
        }
        if (a2 <= 0) {
            return 0.0;
        }
        return new BetaRegularized(this.k - a2, 1 + a2).evaluate(1.0 - this.E);
    }

    @Override
    public double entropy() {
        double a2 = Math.PI * 2 * Math.exp(1.0) * (double)this.k * this.E * (1.0 - this.E);
        a2 = Math.log(a2) / Math.log(2.0);
        return a2 *= 0.5;
    }

    @Override
    public double skew() {
        double a2 = 1.0 - 2.0 * this.E;
        return a2 /= Math.sqrt((double)this.k * this.E * (1.0 - this.E));
    }

    @Override
    public double median() {
        return Math.floor((double)this.k * this.E);
    }

    private double b(double a2, double a3, double a4) {
        BinomialDistribution a5;
        block4: {
            if (!(a5.L >= a3)) break block4;
            while (true) {
                double a6;
                block6: {
                    block5: {
                        double d2;
                        if (a2 == 0.0) break block5;
                        a6 = a5.cdf(a2 - a4);
                        if (!(d2 < a3)) break block6;
                    }
                    return a2;
                }
                a2 = Math.max(0.0, a2 - a4);
                a5.L = a6;
            }
        }
        while ((a2 = Math.min(a2 + a4, (double)a5.k)) != (double)a5.k) {
            double d3;
            a5.L = a5.cdf(a2);
            if (!(d3 >= a3)) continue;
        }
        return a2;
    }

    public BinomialDistribution(int n, double p) {
        this.k = n;
        this.E = p;
    }

    @Override
    public double quantile(double u) {
        double a2;
        double d2;
        if (this.E == 0.0 || this.k == 0) {
            return 0.0;
        }
        double a3 = 1.0 - this.E;
        if (a3 == 0.0) {
            return this.k;
        }
        double a4 = (double)this.k * this.E;
        double a5 = Math.sqrt((double)this.k * this.E * a3);
        double a6 = (a3 - this.E) / a5;
        double a7 = 1.0E-9;
        if (u + 1.01E-9 >= 1.0) {
            return this.k;
        }
        NormalDistribution a8 = new NormalDistribution(0.0, 1.0);
        this.L = a8.quantile(u);
        double a9 = Math.floor(a4 + a5 * (this.L + a6 * (this.L * this.L - 1.0) / 6.0) + 0.5);
        if (d2 > (double)this.k) {
            a9 = this.k;
        }
        this.L = this.cdf(a9);
        double a10 = u;
        a10 *= 0.999999936;
        if ((double)this.k < 100000.0) {
            return this.b(a9, a10, 1.0);
        }
        double a11 = Math.floor((double)this.k * 0.001);
        do {
            a2 = a11;
            a9 = this.b(a9, a10, a11);
            a11 = Math.max(1.0, Math.floor(a11 / 100.0));
        } while (a2 > 1.0 && a11 > (double)this.k * 1.0E-15);
        return a9;
    }

    @Override
    public double kurtosis() {
        double a2 = 1.0 - 6.0 * this.E * (1.0 - this.E);
        return a2 /= (double)this.k * this.E * (1.0 - this.E);
    }

    @Override
    public double variance() {
        return (double)this.k * this.E * (1.0 - this.E);
    }

    @Override
    public double moment(double t) {
        double a2 = 1.0 - this.E;
        a2 += this.E * Math.exp(t);
        a2 = Math.pow(a2, this.k);
        return a2;
    }

    @Override
    public double mean() {
        return (double)this.k * this.E;
    }
}

