/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.descriptive.rank;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.descriptive.Statistic;
import java.util.Arrays;

public class Quantile
implements Statistic {
    public final QuantileType type;
    private double[] E;

    public double value(double q2) {
        Object[] objectArray = new Object[1];
        objectArray[0] = q2;
        SuanShuUtils.assertArgument(q2 >= 0.0 && q2 <= 1.0, "0 <= q <= 1; input = %f", objectArray);
        int a2 = 0;
        double a3 = 0.0;
        double a4 = 0.0;
        double a5 = 0.0;
        double a6 = 0.0;
        switch (this.type) {
            case INVERSE_OF_EMPIRICAL_CDF: {
                a3 = 0.0;
                a2 = this.b(q2, a3);
                a4 = this.m(q2, a3, a2);
                a5 = DoubleUtils.compare(a4, 0.0) == 0 ? 0.0 : 1.0;
                break;
            }
            case INVERSE_OF_EMPIRICAL_CDF_WITH_AVERAGING_AT_DISCONTINUITIES: {
                a3 = 0.0;
                a2 = this.b(q2, a3);
                a4 = this.m(q2, a3, a2);
                a5 = DoubleUtils.compare(a4, 0.0) == 0 ? 0.5 : 1.0;
                break;
            }
            case NEAREST_EVEN_ORDER_STATISTICS: {
                a3 = -0.5;
                a2 = this.b(q2, a3);
                a4 = this.m(q2, a3, a2);
                a5 = DoubleUtils.compare(a4, 0.0) == 0 ? (a2 % 2 == 0 ? 0.0 : 1.0) : 1.0;
                break;
            }
            case LINEAR_INTERPOLATION_OF_EMPIRICAL_CDF: {
                a3 = 0.0;
                a2 = this.b(q2, a3);
                a5 = a4 = this.m(q2, a3, a2);
                break;
            }
            case MIDWAY_THROUGH_STEPS_OF_EMPIRICAL_CDF: {
                a3 = 0.5;
                a2 = this.b(q2, a3);
                a5 = a4 = this.m(q2, a3, a2);
                break;
            }
            case MINITAB_SPSS: {
                a3 = q2;
                a2 = this.b(q2, a3);
                a5 = a4 = this.m(q2, a3, a2);
                break;
            }
            case S: {
                a3 = 1.0 - q2;
                a2 = this.b(q2, a3);
                a5 = a4 = this.m(q2, a3, a2);
                break;
            }
            case APPROXIMATELY_UNBIASED_IF_DATA_IS_NORMAL: {
                do {
                } while (false);
                a3 = this.b(q2, 0.375, 0.375);
                a2 = this.b(q2, a3);
                a5 = a4 = this.m(q2, a3, a2);
                break;
            }
            default: {
                a3 = this.b(q2, 0.3333333333333333, 0.3333333333333333);
                a2 = this.b(q2, a3);
                a5 = a4 = this.m(q2, a3, a2);
            }
        }
        a6 = this.b(a5, a2);
        return a6;
    }

    @Override
    public double value() {
        throw new UnsupportedOperationException("you must supply a quantile value q");
    }

    @Override
    public void addData(double ... data) {
        int a2;
        int a3;
        int n = this.E == null ? 0 : (a3 = this.E.length);
        this.E = this.E == null ? new double[data.length] : Arrays.copyOf(this.E, this.E.length + data.length);
        int n2 = a2 = 0;
        while (n2 < data.length) {
            this.E[a3 + a2] = data[a2];
            n2 = ++a2;
        }
        Arrays.sort(this.E);
    }

    private double b(double a2, int a3) {
        Quantile a4;
        double a5 = (1.0 - a2) * a4.E[a3 > 0 ? a3 - 1 : 0];
        return a5 += a2 * a4.E[a3 < a4.E.length ? a3 : a4.E.length - 1];
    }

    public Quantile(double[] data) {
        this(data, QuantileType.APPROXIMATELY_MEDIAN_UNBIASED);
    }

    public Quantile(double[] data, QuantileType type) {
        this.type = type;
        this.addData(data);
    }

    private double m(double a2, double a3, double a4) {
        Quantile a5;
        int a6 = a5.E.length;
        return a2 * (double)a6 + a3 - a4;
    }

    @Override
    public long N() {
        return this.E.length;
    }

    private int b(double a2, double a3) {
        Quantile a4;
        int a5 = a4.E.length;
        int a6 = (int)Math.floor(a2 * (double)a5 + a3);
        a6 = a6 > 0 ? a6 : 0;
        a6 = a6 <= a5 ? a6 : a5;
        return a6;
    }

    private double b(double a2, double a3, double a4) {
        return a3 + a2 * (1.0 - a3 - a4);
    }

    public static final class QuantileType
    extends Enum<QuantileType> {
        public static final /* enum */ QuantileType LINEAR_INTERPOLATION_OF_EMPIRICAL_CDF;
        public static final /* enum */ QuantileType MIDWAY_THROUGH_STEPS_OF_EMPIRICAL_CDF;
        private static final /* synthetic */ QuantileType[] E;
        public static final /* enum */ QuantileType MINITAB_SPSS;
        public static final /* enum */ QuantileType NEAREST_EVEN_ORDER_STATISTICS;
        public static final /* enum */ QuantileType INVERSE_OF_EMPIRICAL_CDF_WITH_AVERAGING_AT_DISCONTINUITIES;
        public static final /* enum */ QuantileType INVERSE_OF_EMPIRICAL_CDF;
        public static final /* enum */ QuantileType APPROXIMATELY_MEDIAN_UNBIASED;
        public static final /* enum */ QuantileType S;
        public static final /* enum */ QuantileType APPROXIMATELY_UNBIASED_IF_DATA_IS_NORMAL;

        public static QuantileType valueOf(String name) {
            return Enum.valueOf(QuantileType.class, name);
        }

        public static QuantileType[] values() {
            return (QuantileType[])E.clone();
        }

        private QuantileType() {
            QuantileType a2;
        }

        static {
            INVERSE_OF_EMPIRICAL_CDF = new QuantileType();
            INVERSE_OF_EMPIRICAL_CDF_WITH_AVERAGING_AT_DISCONTINUITIES = new QuantileType();
            NEAREST_EVEN_ORDER_STATISTICS = new QuantileType();
            LINEAR_INTERPOLATION_OF_EMPIRICAL_CDF = new QuantileType();
            MIDWAY_THROUGH_STEPS_OF_EMPIRICAL_CDF = new QuantileType();
            MINITAB_SPSS = new QuantileType();
            S = new QuantileType();
            APPROXIMATELY_MEDIAN_UNBIASED = new QuantileType();
            APPROXIMATELY_UNBIASED_IF_DATA_IS_NORMAL = new QuantileType();
            QuantileType[] quantileTypeArray = new QuantileType[9];
            quantileTypeArray[0] = INVERSE_OF_EMPIRICAL_CDF;
            quantileTypeArray[1] = INVERSE_OF_EMPIRICAL_CDF_WITH_AVERAGING_AT_DISCONTINUITIES;
            quantileTypeArray[2] = NEAREST_EVEN_ORDER_STATISTICS;
            quantileTypeArray[3] = LINEAR_INTERPOLATION_OF_EMPIRICAL_CDF;
            quantileTypeArray[4] = MIDWAY_THROUGH_STEPS_OF_EMPIRICAL_CDF;
            quantileTypeArray[5] = MINITAB_SPSS;
            quantileTypeArray[6] = S;
            quantileTypeArray[7] = APPROXIMATELY_MEDIAN_UNBIASED;
            quantileTypeArray[8] = APPROXIMATELY_UNBIASED_IF_DATA_IS_NORMAL;
            E = quantileTypeArray;
        }
    }
}

