/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.descriptive.moment;

import com.numericalmethod.suanshu.stats.descriptive.Statistic;
import com.numericalmethod.suanshu.stats.descriptive.moment.Moments;

public class Skewness
implements Statistic {
    private long k = 0L;
    private double L = 0.0;
    private Moments E = new Moments(2);

    @Override
    public long N() {
        return this.k;
    }

    @Override
    public double value() {
        double a2 = this.b() / (double)(this.k - 1L);
        return this.k >= 2L ? this.L / (double)this.k / Math.pow(a2, 1.5) : 0.0;
    }

    public Skewness() {
    }

    @Override
    public void addData(double ... data) {
        if (this.k == 0L) {
            this.k = data.length;
            this.E.addData(data);
            this.L = Moments.sumsOfPowersOfDifferences(3, this.E.centralMoment(1), data);
            return;
        }
        Skewness a2 = new Skewness(data);
        double a3 = a2.m() - this.m();
        double a4 = this.b();
        double a5 = a2.b();
        long a6 = this.k + a2.k;
        double a7 = 3.0 * a3 * ((double)this.k * a5 - (double)a2.k * a4) / (double)a6;
        double a8 = (double)this.k / (double)a6;
        a8 *= a3 * (double)a2.k;
        a8 = a8 * a8 * a8;
        this.L += a2.L + a7 + (a8 *= 1.0 / (double)a2.k / (double)a2.k - 1.0 / (double)this.k / (double)this.k);
        this.E.addData(data);
        this.k = a6;
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = this.value();
        objectArray[1] = this.k;
        return String.format("skew: %f; N: %d", objectArray);
    }

    private double m() {
        Skewness a2;
        return a2.E.centralMoment(1);
    }

    public Skewness(Skewness that) {
        this.k = that.k;
        this.E = new Moments(that.E);
        this.L = that.L;
    }

    public Skewness(double[] data) {
        this.addData(data);
    }

    private double b() {
        Skewness a2;
        return a2.E.centralMoment(2) * (double)a2.E.N();
    }

    public double sample() {
        double a2 = this.E.centralMoment(2);
        return this.L / (double)this.k / Math.pow(a2, 1.5);
    }
}

