/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.descriptive;

import com.numericalmethod.suanshu.matrix.doubles.IsMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class CorrelationMatrix
extends DenseMatrix {
    public CorrelationMatrix(Matrix cov) {
        super(cov.nCols(), cov.nCols());
        int a2;
        SuanShuUtils.assertArgument(IsMatrix.symmetric(cov), "the covariance matrix must be symmetric", new Object[0]);
        Vector a3 = CreateVector.diagonal(cov);
        DenseMatrix a4 = new DenseMatrix(this);
        int n = a2 = 1;
        while (n <= this.nCols()) {
            int n2 = a2;
            while (n2 <= this.nRows()) {
                int a5;
                a4.set(a2, a5, cov.get(a2, a5) / Math.sqrt(a3.get(a2)) / Math.sqrt(a3.get(a5)));
                a4.set(a5, a2, cov.get(a2, a5) / Math.sqrt(a3.get(a2)) / Math.sqrt(a3.get(a5)));
                n2 = ++a5;
            }
            n = ++a2;
        }
        this.overwrite(a4);
    }
}

