/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.cointegration;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.cointegration.CointegrationMLE;
import com.numericalmethod.suanshu.stats.cointegration.JohansenAsymptoticDistribution;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;

public class JohansenTest {
    private final JohansenAsymptoticDistribution.TrendType k;
    private final JohansenAsymptoticDistribution.Test L;
    private final JohansenAsymptoticDistribution[] E;

    public JohansenTest(JohansenAsymptoticDistribution.Test test, JohansenAsymptoticDistribution.TrendType trend, int dim, int nSim, int nT) {
        int a2;
        this.L = test;
        this.k = trend;
        this.E = new JohansenAsymptoticDistribution[dim];
        int n = a2 = 0;
        while (n < dim) {
            this.E[a2] = new JohansenAsymptoticDistribution(test, trend, dim - a2, dim - a2 <= 2 ? Math.max(5000, nSim) : nSim, nT, new UniformRng().nextLong());
            n = ++a2;
        }
    }

    public JohansenTest(JohansenAsymptoticDistribution.Test test, JohansenAsymptoticDistribution.TrendType trend, int dim) {
        this(test, trend, dim, 500, 500);
    }

    public int r(CointegrationMLE cointegrationMle, double level) {
        int a2;
        Object[] objectArray = new Object[1];
        objectArray[0] = this.L.toString();
        SuanShuUtils.assertArgument(cointegrationMle.test == this.L, "this <tt>JohansenTest</tt> test only for %s", objectArray);
        double a3 = 1.0 - level;
        double[] a4 = cointegrationMle.getStats().toArray();
        int n = a2 = 0;
        while (n < a4.length && !(a4[a2] < this.E[a2].quantile(a3))) {
            n = ++a2;
        }
        return a2;
    }

    public JohansenTest(CointegrationMLE cointegrationMle) {
        this(cointegrationMle.test, JohansenAsymptoticDistribution.TrendType.RESTRICTED_CONSTANT, cointegrationMle.getStats().size());
    }
}

