/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.cointegration;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.stats.cointegration.JohansenAsymptoticDistribution;
import com.numericalmethod.suanshu.stats.descriptive.rank.Max;
import com.numericalmethod.suanshu.stats.stochasticprocess.timepoints.EvenlySpacedGrid;
import com.numericalmethod.suanshu.stats.stochasticprocess.timepoints.TimeGrid;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.Realization;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.brownian.RandomWalk;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.integration.Filtration;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.integration.FiltrationFunction;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.integration.IntegralDB;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.integration.IntegralDt;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.integration.sde.Construction;

public class JohansenAsymptoticDistributionSimulation {
    private final F i;
    private final int G;
    private final int F;
    private final JohansenAsymptoticDistribution.Test k;
    private final TimeGrid L;
    private final Construction E;

    public double[] simulation() {
        int a2;
        double[] a3 = new double[this.G];
        int n = a2 = 0;
        while (n < this.G) {
            double a4;
            int a5;
            Realization[] a6 = new Realization[this.F];
            int n2 = a5 = 0;
            while (n2 < this.F) {
                a6[a5] = this.E.nextRealization(0.0);
                n2 = ++a5;
            }
            FiltrationFunction[] a22 = this.i.evaluate(a6);
            DenseMatrix a7 = this.b(a6, a22);
            DenseMatrix a8 = this.b(a22);
            a3[a2] = a4 = this.b(this.k, a7, a8);
            n = ++a2;
        }
        return a3;
    }

    public void seed(long ... seeds) {
        this.E.seed(seeds[0]);
    }

    private double b(JohansenAsymptoticDistribution.Test a2, Matrix a3, Matrix a4) {
        Matrix a5 = a3.multiply(new Inverse(a4)).multiply(a3.t());
        switch (a2) {
            case EIGEN: {
                double[] a6 = new Eigen(a5).getRealEigenvalues();
                Max a7 = new Max(a6);
                return a7.value();
            }
            case TRACE: {
                do {
                } while (false);
                return MatrixMeasure.tr(a5);
            }
        }
        throw new RuntimeException("please specify a valid test specification");
    }

    private DenseMatrix b(FiltrationFunction[] a2) {
        int a3;
        int a4 = a2.length;
        DenseMatrix a5 = new DenseMatrix(a4, a4);
        int n = a3 = 0;
        while (n < a4) {
            int a6;
            int n2 = a6 = 0;
            while (n2 < a4) {
                JohansenAsymptoticDistributionSimulation a7;
                final FiltrationFunction a8 = a2[a3];
                final FiltrationFunction a9 = a2[a6];
                FiltrationFunction a10 = new FiltrationFunction(){

                    @Override
                    public void setFT(Filtration FT) {
                        super.setFT(FT);
                    }
                    {
                        1 a2;
                    }

                    @Override
                    public double evaluate(int t) {
                        double a2 = a8.evaluate(t);
                        double a3 = a9.evaluate(t);
                        return a2 * a3;
                    }
                };
                double a11 = new IntegralDt(a10).integral(new Filtration(a7.E.nextRealization(0.0)));
                a5.set(a3 + 1, a6 + 1, a11);
                n2 = ++a6;
            }
            n = ++a3;
        }
        return a5;
    }

    public JohansenAsymptoticDistributionSimulation(JohansenAsymptoticDistribution.Test test, F F2, int dr, int nSim, int nT) {
        this.k = test;
        this.i = F2;
        this.F = dr;
        this.G = nSim;
        this.L = new EvenlySpacedGrid(0.0, 1.0, nT);
        this.E = new RandomWalk(this.L);
    }

    private DenseMatrix b(Realization[] a2, FiltrationFunction[] a3) {
        int a4;
        int a5 = a2.length;
        int a6 = a3.length;
        DenseMatrix a7 = new DenseMatrix(a5, a6);
        int n = a4 = 0;
        while (n < a5) {
            int a8;
            Filtration a9 = new Filtration(a2[a4]);
            int n2 = a8 = 0;
            while (n2 < a6) {
                double a10 = new IntegralDB(a3[a8]).integral(a9);
                a7.set(a4 + 1, a8 + 1, a10);
                n2 = ++a8;
            }
            n = ++a4;
        }
        return a7;
    }

    public static interface F {
        public FiltrationFunction[] evaluate(Realization[] var1);
    }
}

