/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.cointegration;

import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.Cholesky;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.cointegration.AuxiliaryRegression1;
import com.numericalmethod.suanshu.stats.cointegration.AuxiliaryRegression2;
import com.numericalmethod.suanshu.stats.cointegration.JohansenAsymptoticDistribution;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime.SimpleMultiVariateTimeSeries;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class CointegrationMLE {
    public final boolean intercept;
    private final Matrix F;
    public final JohansenAsymptoticDistribution.Test test;
    private final double[] k;
    private final Vector L;
    private final DenseMatrix E;

    public ImmutableVector getEigenvalues() {
        return new ImmutableVector(this.L);
    }

    static {
        Package.getInstance("STATS").isValidated();
    }

    public ImmutableMatrix alpha() {
        return new ImmutableMatrix(this.F);
    }

    public CointegrationMLE(SimpleMultiVariateTimeSeries ts, boolean intercept, int p) {
        this(ts, intercept, p, null, JohansenAsymptoticDistribution.Test.EIGEN);
    }

    public ImmutableVector getStats() {
        return new ImmutableVector(new DenseVector(this.k));
    }

    public ImmutableVector beta(int r2) {
        return new ImmutableVector(this.E.getColumn(r2));
    }

    public ImmutableMatrix beta() {
        return new ImmutableMatrix(this.E);
    }

    public CointegrationMLE(SimpleMultiVariateTimeSeries ts, boolean intercept, int p, Matrix D, JohansenAsymptoticDistribution.Test test) {
        int a2;
        int a3;
        SuanShuUtils.assertArgument(p >= 1, "p >= 1", new Object[0]);
        this.intercept = intercept;
        this.test = test;
        int a4 = ts.dimension();
        int a5 = ts.size();
        int n = D == null ? 0 : (a3 = D.nCols());
        SuanShuUtils.assertArgument(D == null || D.nRows() == a5, "D and the multivariate time series do not have the same number of rows", new Object[0]);
        int a6 = a5 - p;
        int a7 = a4 * (p - 1) + a3 + (intercept ? 1 : 0);
        SuanShuUtils.assertArgument(a5 - p > a7 + p * (p + 1) / 2, "the multivariate time series does not have enough number of rows", new Object[0]);
        AuxiliaryRegression1 a8 = new AuxiliaryRegression1(ts, p, D, intercept);
        AuxiliaryRegression2 a9 = new AuxiliaryRegression2(ts, p, D, intercept);
        ImmutableMatrix a10 = a8.errors();
        ImmutableMatrix a11 = a9.errors();
        Matrix a12 = a10.t().multiply(a10).scaled(1.0 / (double)a6);
        Matrix a13 = a10.t().multiply(a11).scaled(1.0 / (double)a6);
        Matrix a14 = a13.t();
        Matrix a15 = a11.t().multiply(a11).scaled(1.0 / (double)a6);
        LowerTriangularMatrix a16 = new Cholesky(a15).L();
        Inverse a17 = new Inverse(a16);
        Matrix a18 = a17.multiply(a14).multiply(new Inverse(a12)).multiply(a13).multiply(a17.t());
        Eigen a19 = new Eigen(a18);
        this.L = new DenseVector(a19.getRealEigenvalues());
        int a20 = this.L.size();
        this.E = new DenseMatrix(a4, a20);
        this.k = new double[a20];
        int n2 = a2 = 0;
        while (n2 < a20) {
            Eigen.Property a21 = a19.getProperty(a2);
            if (test == JohansenAsymptoticDistribution.Test.EIGEN) {
                this.k[a2] = (double)(-a6) * Math.log(1.0 - a21.eigenvalue().doubleValue());
            } else if (a2 == 0) {
                this.k[a20 - a2 - 1] = (double)(-a6) * Math.log(1.0 - a19.getProperty(a20 - a2 - 1).eigenvalue().doubleValue());
            } else {
                this.k[a20 - a2 - 1] = Math.log(1.0 - a19.getProperty(a20 - a2 - 1).eigenvalue().doubleValue());
                int n3 = a20 - a2 - 1;
                this.k[n3] = this.k[n3] * (double)(-a6);
                int n4 = a20 - a2 - 1;
                this.k[n4] = this.k[n4] + this.k[a20 - a2];
            }
            Vector a22 = a17.t().multiply(a21.eigenVector());
            a22 = a22.scaled(1.0 / a22.get(1));
            this.E.setColumn(a2 + 1, a22);
            n2 = ++a2;
        }
        this.F = a13.multiply(this.E).multiply(new Inverse(this.E.t().multiply(a15).multiply(this.E)));
    }

    public CointegrationMLE(SimpleMultiVariateTimeSeries ts, boolean intercept) {
        this(ts, intercept, 2);
    }
}

