/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.signalprocessing;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.RandomNumberGenerator;
import com.numericalmethod.suanshu.stats.random.multivariate.IID;
import com.numericalmethod.suanshu.stats.random.univariate.InverseTransformSampling;
import com.numericalmethod.suanshu.stats.random.univariate.normal.NormalRng;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;
import java.util.Arrays;

public class Innovations {
    private double[] E;

    private void b(double[] a2) {
        a.E = Arrays.copyOf(a2, a2.length);
    }

    public Innovations(int length, UnivariateDistribution dist, double mu, double var) {
        this(length, dist, mu, var, new UniformRng());
    }

    public Innovations(int length, RandomNumberGenerator rng, long seed) {
        if (seed > 0L) {
            long[] lArray = new long[1];
            lArray[0] = seed;
            rng.seed(lArray);
        }
        double[] a2 = new IID(rng, length).nextVector();
        this.b(a2);
    }

    public Innovations(int length) {
        this(length, 0.0, 1.0, -1L);
    }

    public Innovations(int length, UnivariateDistribution dist) {
        this(length, dist, 0.0, 1.0, new UniformRng());
    }

    public Innovations(double[] innovations) {
        this.b(innovations);
    }

    public double[] toArray(int length) {
        SuanShuUtils.assertArgument(length <= this.E.length, "there are not enough innovations", new Object[0]);
        return Arrays.copyOf(this.E, this.E.length);
    }

    public Innovations(Innovations innovation) {
        this.b(innovation.E);
    }

    public Innovations(int length, double mu, double var, long seed) {
        this(length, new NormalRng(mu, Math.sqrt(var)), seed);
    }

    public Innovations(int length, double mu, double var) {
        this(length, mu, var, -1L);
    }

    public double[] toArray() {
        return this.toArray(this.E.length);
    }

    public Innovations(int length, UnivariateDistribution dist, double mu, double var, RandomLongGenerator uniform) {
        int a2;
        double[] a3 = new double[length];
        InverseTransformSampling a4 = new InverseTransformSampling(dist, uniform);
        double a5 = dist.mean();
        double a6 = dist.variance();
        int n = a2 = 0;
        while (n < length) {
            a3[a2] = (a4.nextDouble() - a5 + mu) * Math.sqrt(var / a6);
            n = ++a2;
        }
        this.b(a3);
    }

    public Innovations(int length, RandomNumberGenerator rng) {
        this(length, rng, -1L);
    }
}

