/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.univariate.bracketsearch;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.optimization.univariate.bracketsearch.BracketSearch;

public class Brent
extends BracketSearch {
    public double v;
    private final double E = 1.0 - 1.0 / Constant.GOLDEN_RATIO;
    public double incLast = 0.0;
    public double fv;
    public double w;
    public double fw;

    @Override
    public double search(double lower, double initial, double upper) {
        this.w = this.v = initial;
        this.fw = this.fv = this.f.evaluate(initial);
        super.search(lower, initial, upper);
        return this.xmin;
    }

    @Override
    public boolean isMinFound() {
        Brent a2;
        boolean a3 = false;
        double a4 = 0.5 * (a2.xu - a2.xl);
        double a5 = a2.tol * Math.abs(a2.xmin) + Constant.EPSILON;
        double a6 = 2.0 * a5;
        if (0.5 * (a2.xu - a2.xl) + Math.abs(a2.xmin - a4) <= a6) {
            a3 = true;
        }
        return a3;
    }

    @Override
    public void updateStates() {
        Brent a2;
        if (a2.fnext < a2.fmin) {
            a2.v = a2.w;
            a2.fv = a2.fw;
            a2.w = a2.xmin;
            a2.fw = a2.fmin;
        } else if (a2.fnext <= a2.fw || a2.w == a2.xmin) {
            a2.v = a2.w;
            a2.fv = a2.fw;
            a2.w = a2.xnext;
            a2.fw = a2.fnext;
        } else if (a2.fnext <= a2.fv || a2.v == a2.xmin || a2.v == a2.w) {
            a2.v = a2.xnext;
            a2.fv = a2.fnext;
        }
        super.updateStates();
    }

    public double search(double lower, double upper) {
        double a2 = lower + this.E * (upper - lower);
        this.search(lower, a2, upper);
        return this.xmin;
    }

    @Override
    public double xnext() {
        Brent a2;
        double a3 = 0.0;
        double a4 = a2.tol * Math.abs(a2.xmin) + Constant.EPSILON;
        double a5 = 0.5 * (a2.xl + a2.xu);
        a3 = a2.E * ((a2.xmin < a5 ? a2.xu : a2.xl) - a2.xmin);
        if (Math.abs(a2.incLast) > a4) {
            double a6;
            double a7;
            double d2;
            double a8 = a2.xmin;
            double a9 = a2.fmin;
            double a10 = (a8 - a2.w) * (a9 - a2.fv);
            double a11 = (a8 - a2.v) * (a9 - a2.fw);
            double a12 = (a8 - a2.v) * a11 - (a8 - a2.w) * a10;
            a11 = 2.0 * (a11 - a10);
            if (d2 > 0.0) {
                a12 = -a12;
            } else {
                a11 = -a11;
            }
            if (Math.abs(a12) < Math.abs(0.5 * a11 * a2.incLast) && a12 > a11 * (a2.xl - a8) && a12 < a11 * (a2.xu - a8) && ((a7 = a2.xmin + (a3 = a12 / a11)) - a2.xl < (a6 = 2.0 * a4) || a2.xu - a7 < a6)) {
                a3 = a8 < a5 ? a4 : -a4;
            }
        }
        a2.incLast = a3;
        return a2.xmin + a3;
    }
}

