/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.univariate;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleArrayMath;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.univariate.UnivariateMinimizer;
import com.numericalmethod.suanshu.parallel.LoopBody;
import com.numericalmethod.suanshu.parallel.ParallelExecutor;

public class GridSearch
implements UnivariateMinimizer {
    public double xmin;
    public double fmin;
    public double tol;
    public UnivariateRealFunction f;
    public int maxIterations;

    @Override
    public double search(double lower, double initial, double upper) {
        SuanShuUtils.assertArgument(lower < upper, "invalid bracket interval", new Object[0]);
        this.fmin = Double.POSITIVE_INFINITY;
        double a2 = (upper - lower) / (double)this.maxIterations;
        final double[] a3 = R.seq(lower, upper, a2);
        final double[] a4 = new double[a3.length];
        try {
            new ParallelExecutor().forLoop(0, a3.length, new LoopBody(){
                {
                    1 a2;
                }

                @Override
                public void run(int i2) throws Exception {
                    double a2;
                    a4[i2] = a2 = GridSearch.this.f.evaluate(a3[i2]);
                }
            });
            this.fmin = DoubleArrayMath.min(a4);
            int a5 = DoubleUtils.minIndex(a4);
            this.xmin = a3[a5];
        }
        catch (Exception a6) {
            double a7;
            double d2 = a7 = lower;
            while (d2 <= upper) {
                double d3;
                double a8 = this.f.evaluate(a7);
                if (d3 < this.fmin) {
                    this.fmin = a8;
                    this.xmin = a7;
                }
                d2 = a7 + a2;
            }
        }
        return this.xmin;
    }

    @Override
    public void solve(UnivariateRealFunction f2, double tol, int maxIterations) {
        this.f = f2;
        double a2 = Math.sqrt(Constant.EPSILON);
        this.tol = tol < a2 ? a2 : tol;
        this.maxIterations = maxIterations;
    }

    @Override
    public double minimum() {
        return this.fmin;
    }

    public double search(double lower, double upper) {
        return this.search(lower, Double.NaN, upper);
    }
}

