/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent;

import com.numericalmethod.suanshu.analysis.differentiation.multivariate.HessianFunction;
import com.numericalmethod.suanshu.analysis.function.matrix.RntoMatrix;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.matrix.doubles.operation.positivedefinite.GoldfeldQuandtTrotter;
import com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent.SteepestDescent;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class NewtonRaphson
extends SteepestDescent {
    private RntoMatrix E;

    public void solve(RealScalarFunction f2, RealVectorFunction g2, RntoMatrix H, double tol, int maxIterations) {
        this.E = H;
        super.solve(f2, g2, tol, maxIterations);
    }

    @Override
    public SteepestDescent.SteepestDescentImpl getImplementation() {
        return new NewtonRaphsonImpl(null);
    }

    @Override
    public void solve(RealScalarFunction f2, RealVectorFunction g2, double tol, int maxIterations) {
        this.solve(f2, g2, new HessianFunction(f2), tol, maxIterations);
    }

    public static class 1 {
    }

    private class NewtonRaphsonImpl
    extends SteepestDescent.SteepestDescentImpl {
        private NewtonRaphsonImpl() {
            NewtonRaphsonImpl a2;
        }

        public /* synthetic */ NewtonRaphsonImpl(1 a3) {
            a4();
            NewtonRaphsonImpl a4;
        }

        @Override
        public Vector getDirection(Vector xk) {
            this.gk = NewtonRaphson.this.g.evaluate(xk.toArray());
            Matrix a2 = NewtonRaphson.this.E.evaluate(xk.toArray());
            Matrix a3 = a2.ONE();
            try {
                a3 = new Inverse(a2);
            }
            catch (Exception a4) {
                try {
                    GoldfeldQuandtTrotter a5 = new GoldfeldQuandtTrotter(a2, Double.POSITIVE_INFINITY);
                    a3 = new Inverse((Matrix)a5);
                }
                catch (Exception a6) {
                    a3 = a2.ONE();
                }
            }
            Vector a7 = a3.multiply(this.gk);
            a7 = a7.scaled(-1.0);
            return a7;
        }
    }
}

