/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent;

import com.numericalmethod.suanshu.analysis.differentiation.multivariate.JacobianFunction;
import com.numericalmethod.suanshu.analysis.function.matrix.RntoMatrix;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.matrix.doubles.operation.positivedefinite.MatthewsDavies;
import com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent.SteepestDescent;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class GaussNewton
extends SteepestDescent {
    private RntoMatrix L;
    private RealVectorFunction E;

    @Override
    public SteepestDescent.SteepestDescentImpl getImplementation() {
        return new GaussNewtonImpl(this.E, this.L, null);
    }

    public void solve(RealVectorFunction vf, double tol, int maxIterations) {
        this.solve(vf, new JacobianFunction(vf), tol, maxIterations);
    }

    private static RealScalarFunction b(final RealVectorFunction a2) {
        return new RealScalarFunction(){

            @Override
            public double evaluate(double ... x) {
                Vector a22 = a2.evaluate(x);
                return a22.innerProduct(a22);
            }

            @Override
            public int dimensionOfRange() {
                return 1;
            }
            {
                2 a22;
            }

            @Override
            public int dimensionOfDomain() {
                return a2.dimensionOfDomain();
            }
        };
    }

    private static RealVectorFunction b(final RealVectorFunction a2, final RntoMatrix a3) {
        return new RealVectorFunction(){

            @Override
            public int dimensionOfDomain() {
                return a2.dimensionOfDomain();
            }
            {
                1 a22;
            }

            @Override
            public int dimensionOfRange() {
                return a2.dimensionOfDomain();
            }

            @Override
            public Vector evaluate(double ... x) {
                Matrix a22 = a3.evaluate(x).t();
                DenseMatrix a32 = new DenseMatrix(a2.evaluate(x));
                Matrix a4 = a22.multiply(a32).scaled(2.0);
                return new DenseVector(MatrixUtils.to1DArray(a4));
            }
        };
    }

    public void solve(RealVectorFunction vf, RntoMatrix J, double tol, int maxIterations) {
        this.E = vf;
        this.L = J;
        super.solve(GaussNewton.b(vf), GaussNewton.b(vf, J), tol, maxIterations);
    }

    private class GaussNewtonImpl
    extends SteepestDescent.SteepestDescentImpl {
        private Matrix F;
        private final RntoMatrix k;
        private final RealVectorFunction L;
        private final RealScalarFunction E;

        private GaussNewtonImpl(RealVectorFunction a2, RntoMatrix a3) {
            GaussNewtonImpl a4;
            a4.L = a2;
            a4.E = GaussNewton.b(a2);
            a4.k = a3;
        }

        public /* synthetic */ GaussNewtonImpl(RealVectorFunction a3, RntoMatrix a4, 1 a5) {
            a6(a3, a4);
            GaussNewtonImpl a6;
        }

        @Override
        public Vector getDirection(Vector xk) {
            this.F = this.k.evaluate(xk.toArray());
            this.gk = GaussNewton.this.g.evaluate(xk.toArray());
            Matrix a2 = this.F.t().multiply(this.F).scaled(2.0);
            MatthewsDavies a3 = new MatthewsDavies(a2);
            return new Inverse((Matrix)a3).multiply(this.gk).scaled(-1.0);
        }
    }
}

