/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.quasinewton;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.optimization.unconstrained.linesearch.Fletcher;
import com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent.SteepestDescent;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public abstract class QuasiNewton
extends SteepestDescent {

    public abstract class QuasiNewtonImpl
    extends SteepestDescent.SteepestDescentImpl {
        private double E;
        public final int n;
        public Vector dk;
        public Matrix Sk;

        @Override
        public double linesearch(Vector xk, Vector dk) {
            if (this.E <= QuasiNewton.this.tol) {
                return 1.0E-5;
            }
            this.ak = this.linesearch.linesearch(xk, dk);
            return this.ak;
        }

        @Override
        public Vector getDirection(Vector xk) {
            Vector a2 = this.gk;
            this.gk = QuasiNewton.this.g.evaluate(xk.toArray());
            if (this.dk != null) {
                Vector a3 = this.gk.minus(a2);
                this.E = a3.norm();
                if (this.E <= QuasiNewton.this.tol) {
                    return this.dk;
                }
                this.updateSk(a3);
            }
            this.dk = this.Sk.multiply(this.gk).scaled(-1.0);
            return this.dk;
        }

        public QuasiNewtonImpl() {
            this.n = QuasiNewton.this.f.dimensionOfDomain();
            this.Sk = new DenseMatrix(this.n, this.n).ONE();
            this.dk = null;
            this.E = Double.POSITIVE_INFINITY;
            this.linesearch = new Fletcher(0.1, 0.7, 0.1, 0.75, 1.0E-10, 600);
            this.linesearch.solve(QuasiNewton.this.f, QuasiNewton.this.g);
        }

        public abstract void updateSk(Vector var1);
    }
}

