/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.conjugatedirection;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent.SteepestDescent;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class Zangwill
extends SteepestDescent {
    private double E;

    @Override
    public void solve(RealScalarFunction f2, RealVectorFunction g2, double tol, int maxIterations) {
        this.solve(f2, g2, tol, Constant.EPSILON, maxIterations);
    }

    public void solve(RealScalarFunction f2, RealVectorFunction g2, double tol, double tol2, int maxIterations) {
        this.E = tol2;
        super.solve(f2, g2, tol, maxIterations);
    }

    @Override
    public SteepestDescent.SteepestDescentImpl getImplementation() {
        return new ZangwillImpl(this.E, null);
    }

    public static class 1 {
    }

    private class ZangwillImpl
    extends SteepestDescent.SteepestDescentImpl {
        private Vector[] i;
        public final int n;
        public final double threshold2;
        private Vector G;
        private double F;
        private double k;
        private int L;
        private double E;

        @Override
        public double linesearch(Vector xk, Vector dk) {
            Vector a2 = xk.add(dk);
            double a3 = this.b(a2, dk);
            return a3 += 1.0;
        }

        @Override
        public Vector getDirection(Vector xk) {
            int a2;
            Vector a3 = xk;
            if (this.G == null) {
                int n = a2 = 1;
                while (n <= this.n) {
                    this.i[a2] = new DenseVector(this.n);
                    this.i[a2].set(a2, 1.0);
                    n = ++a2;
                }
            } else {
                double d2;
                double a4 = this.E * this.k / this.F;
                if (d2 > this.threshold2) {
                    this.i[this.L] = this.G;
                    this.k = a4;
                }
            }
            this.E = Double.NEGATIVE_INFINITY;
            int n = a2 = 1;
            while (n <= this.n) {
                double a5 = this.b(a3, this.i[a2]);
                a3 = a3.add(this.i[a2].scaled(a5));
                if (a5 > this.E) {
                    this.L = a2;
                    this.E = a5;
                }
                n = ++a2;
            }
            this.G = a3.minus(xk);
            this.F = this.G.norm();
            return this.G;
        }

        private ZangwillImpl(double a2) {
            ZangwillImpl a3;
            a3.n = a3.Zangwill.this.f.dimensionOfDomain();
            a3.G = null;
            a3.i = new Vector[a3.n + 1];
            a3.L = Integer.MIN_VALUE;
            a3.E = Double.NaN;
            a3.F = Double.NaN;
            a3.k = 1.0;
            a3.threshold2 = a2;
        }

        private double b(Vector a2, Vector a3) {
            double a4;
            ZangwillImpl a5;
            double a6 = a5.linesearch.linesearch(a2, a3);
            if (a6 >= (a4 = a5.linesearch.linesearch(a2, a3.scaled(-1.0)))) {
                return a6;
            }
            return -a4;
        }

        public /* synthetic */ ZangwillImpl(double a3, 1 a4) {
            a5(a3);
            ZangwillImpl a5;
        }
    }
}

